/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Modification;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationPayload;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationResult;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.TimestampParser;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IncrementModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.UpdateModel;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class UpdateFetcher
extends MutationFetcher<UpdateModel, DataFetcherResult<Object>> {
    public UpdateFetcher(UpdateModel model, MappingModel mappingModel) {
        super(model, mappingModel);
    }

    @Override
    protected MutationPayload<DataFetcherResult<Object>> getPayload(DataFetchingEnvironment environment, StargateGraphqlContext context) throws UnauthorizedException {
        Function<String, Object> getArgument;
        Predicate<String> hasArgument;
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        EntityModel entityModel = ((UpdateModel)this.model).getEntity();
        Keyspace keyspace = context.getDataStore().schema().keyspace(entityModel.getKeyspaceName());
        if (((UpdateModel)this.model).getEntityArgumentName().isPresent()) {
            Map entity = (Map)environment.getArgument(((UpdateModel)this.model).getEntityArgumentName().get());
            hasArgument = entity::containsKey;
            getArgument = entity::get;
        } else {
            hasArgument = arg_0 -> ((DataFetchingEnvironment)environment).containsArgument(arg_0);
            getArgument = arg_0 -> ((DataFetchingEnvironment)environment).getArgument(arg_0);
        }
        List<BuiltCondition> whereConditions = this.bindWhere(((UpdateModel)this.model).getWhereConditions(), hasArgument, getArgument, entityModel::validateForUpdate, keyspace);
        List<BuiltCondition> ifConditions = this.bindIf(((UpdateModel)this.model).getIfConditions(), hasArgument, getArgument, keyspace);
        Collection<ValueModifier> modifiers = !((UpdateModel)this.model).getIncrementModels().isEmpty() ? this.buildIncrementModifiers(((UpdateModel)this.model).getIncrementModels(), keyspace, hasArgument, getArgument) : this.buildModifiers(entityModel, keyspace, hasArgument, getArgument);
        Optional<Long> timestamp = TimestampParser.parse(((UpdateModel)this.model).getCqlTimestampArgumentName(), environment);
        AbstractBound<?> query = this.buildUpdateQuery(entityModel, modifiers, whereConditions, ifConditions, timestamp, context);
        List primaryKey = TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query));
        this.authorizeUpdate(entityModel, primaryKey, context);
        Function<List<MutationResult>, DataFetcherResult<Object>> resultBuilder = this.getResultBuilder(selectionSet, environment);
        return new MutationPayload<DataFetcherResult<Object>>((BoundQuery)query, primaryKey, resultBuilder);
    }

    private Collection<ValueModifier> buildIncrementModifiers(List<IncrementModel> incrementModels, Keyspace keyspace, Predicate<String> hasArgument, Function<String, Object> getArgument) {
        ArrayList<ValueModifier> modifiers = new ArrayList<ValueModifier>();
        for (IncrementModel incrementModel : incrementModels) {
            FieldModel column = incrementModel.getField();
            if (hasArgument.test(incrementModel.getArgumentName())) {
                Object graphqlValue = getArgument.apply(incrementModel.getArgumentName());
                Modification.Operation operation = incrementModel.isPrepend() ? Modification.Operation.PREPEND : Modification.Operation.APPEND;
                modifiers.add(ValueModifier.of((String)column.getCqlName(), (Value)Value.of((Object)this.toCqlValue(graphqlValue, column.getCqlType(), keyspace)), (Modification.Operation)operation));
            }
            if (!modifiers.isEmpty()) continue;
            throw new IllegalArgumentException("Input object must have at least one non-PK field set for an update");
        }
        return modifiers;
    }

    private Collection<ValueModifier> buildModifiers(EntityModel entityModel, Keyspace keyspace, Predicate<String> hasArgument, Function<String, Object> getArgument) {
        ArrayList<ValueModifier> modifiers = new ArrayList<ValueModifier>();
        for (FieldModel column : entityModel.getRegularColumns()) {
            String graphqlName = column.getGraphqlName();
            if (!hasArgument.test(graphqlName)) continue;
            Object graphqlValue = getArgument.apply(graphqlName);
            modifiers.add(ValueModifier.set((String)column.getCqlName(), (Object)this.toCqlValue(graphqlValue, column.getCqlType(), keyspace)));
        }
        if (modifiers.isEmpty()) {
            throw new IllegalArgumentException("Input object must have at least one non-PK field set for an update");
        }
        return modifiers;
    }

    private AbstractBound<?> buildUpdateQuery(EntityModel entityModel, Collection<ValueModifier> modifiers, List<BuiltCondition> whereConditions, List<BuiltCondition> ifConditions, Optional<Long> timestamp, StargateGraphqlContext context) {
        return (AbstractBound)context.getDataStore().queryBuilder().update(entityModel.getKeyspaceName(), entityModel.getCqlName()).ttl((Integer)((UpdateModel)this.model).getTtl().orElse(null)).timestamp((Long)timestamp.orElse(null)).value(modifiers).where(whereConditions).ifs(ifConditions).ifExists(((UpdateModel)this.model).ifExists()).build().bind(new Object[0]);
    }

    private void authorizeUpdate(EntityModel entityModel, List<TypedKeyValue> primaryKey, StargateGraphqlContext context) throws UnauthorizedException {
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), entityModel.getKeyspaceName(), entityModel.getCqlName(), primaryKey, Scope.MODIFY, SourceAPI.GRAPHQL);
    }

    private Function<List<MutationResult>, DataFetcherResult<Object>> getResultBuilder(DataFetchingFieldSelectionSet selectionSet, DataFetchingEnvironment environment) {
        return queryResults -> {
            DataFetcherResult.Builder result = DataFetcherResult.newResult();
            assert (queryResults.size() == 1);
            MutationResult queryResult = (MutationResult)queryResults.get(0);
            if (queryResult instanceof MutationResult.Failure) {
                result.error((GraphQLError)this.toGraphqlError((MutationResult.Failure)queryResult, this.getCurrentFieldLocation(environment), environment));
            } else {
                LinkedHashMap entityData;
                boolean applied = queryResult instanceof MutationResult.Applied;
                boolean responseContainsEntity = ((UpdateModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).isPresent();
                LinkedHashMap linkedHashMap = entityData = responseContainsEntity ? new LinkedHashMap() : null;
                if (responseContainsEntity && queryResult instanceof MutationResult.NotApplied) {
                    ((MutationResult.NotApplied)queryResult).getRow().ifPresent(row -> this.copyRowToEntity((Row)row, entityData, ((UpdateModel)this.model).getEntity()));
                }
                if (((UpdateModel)this.model).getReturnType() == OperationModel.SimpleReturnType.BOOLEAN) {
                    result.data((Object)applied);
                } else {
                    LinkedHashMap<String, Serializable> response = new LinkedHashMap<String, Serializable>();
                    if (selectionSet.contains(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName())) {
                        response.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), Boolean.valueOf(applied));
                    }
                    if (responseContainsEntity) {
                        String prefix = ((UpdateModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).map(ResponsePayloadModel.EntityField::getName).orElseThrow(AssertionError::new);
                        response.put(prefix, entityData);
                    }
                    result.data(response);
                }
            }
            return result.build();
        };
    }
}

