/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import com.google.common.annotations.VisibleForTesting;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.SchemaFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class SingleSchemaFetcher
extends SchemaFetcher<SchemaSource> {
    private final Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider;

    public SingleSchemaFetcher() {
        this(SchemaSourceDao::new);
    }

    @VisibleForTesting
    public SingleSchemaFetcher(Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider) {
        this.schemaSourceDaoProvider = schemaSourceDaoProvider;
    }

    @Override
    protected SchemaSource get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        String keyspace = this.getKeyspace(environment, context.getDataStore());
        Optional<UUID> version = Optional.ofNullable((String)environment.getArgument("version")).map(UUID::fromString);
        this.authorize(context, keyspace);
        return this.schemaSourceDaoProvider.apply(context.getDataStore()).getSingleVersion(keyspace, version);
    }
}

