/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.core.util.ByteBufferUtils;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.BoundSelect;
import io.stargate.db.query.builder.ColumnOrder;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations.AggregationsFetcherSupport;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryFetcher
extends DmlFetcher<Map<String, Object>> {
    private final AggregationsFetcherSupport aggregationsFetcherSupport;

    public QueryFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
        this.aggregationsFetcherSupport = new AggregationsFetcherSupport(nameMapping, table);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        BoundQuery query = this.buildQuery(environment, context.getDataStore());
        ResultSet resultSet = context.getAuthorizationService().authorizedDataRead(() -> (ResultSet)context.getDataStore().execute(query, __ -> this.buildParameters(environment)).get(), context.getSubject(), this.table.keyspace(), this.table.name(), TypedKeyValue.forSelect((BoundSelect)((BoundSelect)query)), SourceAPI.GRAPHQL);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", resultSet.currentPageRows().stream().map(row -> {
            Map<String, Object> columns = DataTypeMapping.toGraphQLValue(this.nameMapping, this.table, row);
            return this.aggregationsFetcherSupport.addAggregationResults(columns, environment, (Row)row);
        }).collect(Collectors.toList()));
        ByteBuffer pageState = resultSet.getPagingState();
        if (pageState != null) {
            result.put("pageState", ByteBufferUtils.toBase64((ByteBuffer)pageState));
        }
        return result;
    }

    private BoundQuery buildQuery(DataFetchingEnvironment environment, DataStore dataStore) {
        Integer limit = null;
        if (environment.containsArgument("options")) {
            Object limitObj;
            Map options = (Map)environment.getArgument("options");
            Object v0 = limitObj = options == null ? null : options.get("limit");
            if (limitObj != null) {
                limit = limitObj;
            }
        }
        return dataStore.queryBuilder().select().column(this.buildQueryColumns(environment)).function(this.aggregationsFetcherSupport.buildAggregatedFunctions(environment)).from(this.table.keyspace(), this.table.name()).where(this.buildClause(this.table, environment)).limit(limit).orderBy(this.buildOrderBy(environment)).build().bind(new Object[0]);
    }

    private List<ColumnOrder> buildOrderBy(DataFetchingEnvironment environment) {
        if (environment.containsArgument("orderBy")) {
            ArrayList<ColumnOrder> orderBy = new ArrayList<ColumnOrder>();
            List orderList = (List)environment.getArgument("orderBy");
            for (String order : orderList) {
                int split = order.lastIndexOf("_");
                String column = order.substring(0, split);
                boolean desc = order.substring(split + 1).equals("DESC");
                orderBy.add(ColumnOrder.of((String)this.dbColumnGetter.getDBColumnName(this.table, column), (Column.Order)(desc ? Column.Order.DESC : Column.Order.ASC)));
            }
            return orderBy;
        }
        return ImmutableList.of();
    }

    private List<Column> buildQueryColumns(DataFetchingEnvironment environment) {
        List valuesFields = environment.getSelectionSet().getFields("values", new String[0]);
        if (valuesFields.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<Column> queryColumns = new LinkedHashSet<Column>();
        for (SelectedField valuesField : valuesFields) {
            for (SelectedField selectedField : valuesField.getSelectionSet().getFields()) {
                String column;
                if ("__typename".equals(selectedField.getName()) || (column = this.dbColumnGetter.getDBColumnName(this.table, selectedField.getName())) == null) continue;
                queryColumns.add(Column.reference((String)column));
            }
        }
        return ImmutableList.copyOf(queryColumns);
    }
}

