/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.ImmutableParameters;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DbColumnGetter;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.FilterOperator;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    private static final Logger log = LoggerFactory.getLogger(DmlFetcher.class);
    protected final Table table;
    protected final NameMapping nameMapping;
    protected final DbColumnGetter dbColumnGetter;

    protected DmlFetcher(Table table, NameMapping nameMapping) {
        this.table = table;
        this.nameMapping = nameMapping;
        this.dbColumnGetter = new DbColumnGetter(nameMapping);
    }

    protected Parameters buildParameters(DataFetchingEnvironment environment) {
        Object pageState;
        Object pageSize;
        Object serialConsistency;
        Map options = (Map)environment.getArgument("options");
        if (options == null) {
            return DEFAULT_PARAMETERS;
        }
        ImmutableParameters.Builder builder = DEFAULT_PARAMETERS.toBuilder();
        Object consistency = options.get("consistency");
        if (consistency != null) {
            builder.consistencyLevel(ConsistencyLevel.valueOf((String)((String)consistency)));
        }
        if ((serialConsistency = options.get("serialConsistency")) != null) {
            builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)((String)serialConsistency)));
        }
        if ((pageSize = options.get("pageSize")) != null) {
            builder.pageSize(((Integer)pageSize).intValue());
        }
        if ((pageState = options.get("pageState")) != null) {
            builder.pagingState(ByteBuffer.wrap(Base64.getDecoder().decode((String)pageState)));
        }
        return builder.build();
    }

    protected List<BuiltCondition> buildConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<BuiltCondition> where = new ArrayList<BuiltCondition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(condition.getKey());
                where.add(operator.buildCondition(column, condition.getValue(), this.nameMapping));
            }
        }
        return where;
    }

    protected List<BuiltCondition> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, (String)entry.getKey());
            Object whereValue = this.toDBValue(column.type(), entry.getValue());
            relations.add(BuiltCondition.of((String)column.name(), (Predicate)Predicate.EQ, (Object)whereValue));
        }
        return relations;
    }

    protected List<Map<String, Object>> toBatchResults(List<Row> rows, List<Map<String, Object>> originalValues) {
        boolean applied = this.isAppliedBatch(rows);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> originalValue : originalValues) {
            results.add((Map<String, Object>)(applied ? this.toAppliedMutationResultWithOriginalValue(originalValue) : this.toUnappliedBatchResult(rows, originalValue)));
        }
        return results;
    }

    protected Map<String, Object> toBatchResult(List<Row> rows, Map<String, Object> originalValue) {
        return this.isAppliedBatch(rows) ? this.toAppliedMutationResultWithOriginalValue(originalValue) : this.toUnappliedBatchResult(rows, originalValue);
    }

    private Map<String, Object> toUnappliedBatchResult(List<Row> rows, Map<String, Object> originalValue) {
        Map<String, Object> primaryKey = this.table.primaryKeyColumns().stream().collect(Collectors.toMap(SchemaEntity::name, column -> this.toDBValue((Column)column, originalValue.get(column.name()))));
        return (Map)rows.stream().filter(row -> this.matches((Row)row, primaryKey)).findFirst().map(row -> this.toMutationResultSingleRow(originalValue, (Row)row)).orElse(ImmutableMap.of((Object)"applied", (Object)false));
    }

    private boolean matches(Row row, Map<String, Object> primaryKey) {
        for (Map.Entry<String, Object> entry : primaryKey.entrySet()) {
            String name = entry.getKey();
            if (!row.columns().stream().noneMatch(c -> name.equals(c.name())) && entry.getValue().equals(row.getObject(name))) continue;
            return false;
        }
        return true;
    }

    protected CompletableFuture<List<Map<String, Object>>> toListOfMutationResultsAccepted(List<Map<String, Object>> originalValues) {
        ArrayList<ImmutableMap<String, Object>> results = new ArrayList<ImmutableMap<String, Object>>();
        for (Map<String, Object> originalValue : originalValues) {
            results.add(this.toAcceptedMutationResultWithOriginalValue(originalValue));
        }
        return CompletableFuture.completedFuture(results);
    }

    protected Map<String, Object> toMutationResult(ResultSet resultSet, Object originalValue) {
        List rows = resultSet.currentPageRows();
        if (rows.isEmpty()) {
            return this.toAppliedMutationResultWithOriginalValue(originalValue);
        }
        Row row = (Row)rows.iterator().next();
        return this.toMutationResultSingleRow(originalValue, row);
    }

    private ImmutableMap<String, Object> toAppliedMutationResultWithOriginalValue(Object originalValue) {
        return ImmutableMap.of((Object)"value", (Object)originalValue, (Object)"applied", (Object)true);
    }

    protected ImmutableMap<String, Object> toAcceptedMutationResultWithOriginalValue(Object originalValue) {
        return ImmutableMap.of((Object)"value", (Object)originalValue, (Object)"accepted", (Object)true);
    }

    private ImmutableMap<String, Object> toMutationResultSingleRow(Object originalValue, Row row) {
        boolean applied = row.getBoolean("[applied]");
        Map<String, Object> finalValue = applied ? originalValue : DataTypeMapping.toGraphQLValue(this.nameMapping, this.table, row);
        return ImmutableMap.of((Object)"value", finalValue, (Object)"applied", (Object)applied);
    }

    protected boolean containsDirective(OperationDefinition operation, String directive) {
        return operation.getDirectives().stream().anyMatch(d -> d.getName().equals(directive));
    }

    protected CompletableFuture<Map<String, Object>> executeAsyncAccepted(BoundQuery query, Object originalValue, UnaryOperator<Parameters> parameters, StargateGraphqlContext context) {
        context.getDataStore().execute(query, parameters).whenComplete((r, throwable) -> {
            if (throwable != null) {
                log.warn(String.format("The query %s executed within the %s directive failed.", query, "async"), throwable);
            }
        });
        return CompletableFuture.completedFuture(this.toAcceptedMutationResultWithOriginalValue(originalValue));
    }

    protected String getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return column.name();
    }

    protected Column getColumn(Table table, String fieldName) {
        String columnName = this.nameMapping.getCqlName(table, fieldName);
        return table.column(columnName);
    }

    protected Object toDBValue(Column column, Object value) {
        return this.toDBValue(column.type(), value);
    }

    private Object toDBValue(Column.ColumnType type, Object value) {
        return DataTypeMapping.toDBValue(type, value, this.nameMapping);
    }
}

