/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.persistence.graphqlfirst;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.Replication;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableTable;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.schema.graphqlfirst.migration.CassandraSchemaHelper;
import io.stargate.graphql.schema.graphqlfirst.util.Uuids;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSourceDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaSourceDao.class);
    public static final String KEYSPACE_NAME = "stargate_graphql";
    public static final String TABLE_NAME = "schema_source";
    public static final String KEYSPACE_REPLICATION_PROPERTY = "stargate.graphql_first.replication_options";
    private static final Replication DEFAULT_KEYSPACE_REPLICATION = Replication.simpleStrategy((int)1);
    private static final Replication KEYSPACE_REPLICATION = SchemaSourceDao.parseReplication(System.getProperty("stargate.graphql_first.replication_options"));
    @VisibleForTesting
    static final String KEYSPACE_COLUMN_NAME = "keyspace_name";
    @VisibleForTesting
    static final String VERSION_COLUMN_NAME = "version";
    @VisibleForTesting
    static final String LATEST_VERSION_COLUMN_NAME = "latest_version";
    @VisibleForTesting
    static final String CONTENTS_COLUMN_NAME = "contents";
    @VisibleForTesting
    static final String APPLIED_COLUMN_NAME = "[applied]";
    @VisibleForTesting
    static final String DEPLOYMENT_IN_PROGRESS_COLUMN_NAME = "deployment_in_progress";
    private static final int NUMBER_OF_RETAINED_SCHEMA_VERSIONS = 10;
    @VisibleForTesting
    static final Table EXPECTED_TABLE = ImmutableTable.builder().keyspace("stargate_graphql").name("schema_source").addColumns(new Column[]{ImmutableColumn.create((String)"keyspace_name", (Column.Kind)Column.Kind.PartitionKey, (Column.ColumnType)Column.Type.Varchar), ImmutableColumn.create((String)"version", (Column.Kind)Column.Kind.Clustering, (Column.ColumnType)Column.Type.Timeuuid, (Column.Order)Column.Order.DESC), ImmutableColumn.create((String)"contents", (Column.Kind)Column.Kind.Regular, (Column.ColumnType)Column.Type.Varchar), ImmutableColumn.create((String)"latest_version", (Column.Kind)Column.Kind.Static, (Column.ColumnType)Column.Type.Timeuuid), ImmutableColumn.create((String)"deployment_in_progress", (Column.Kind)Column.Kind.Static, (Column.ColumnType)Column.Type.Boolean)}).build();
    private final DataStore dataStore;

    public SchemaSourceDao(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public List<SchemaSource> getAllVersions(String keyspace) throws Exception {
        if (!this.tableExists()) {
            return Collections.emptyList();
        }
        List row = ((ResultSet)this.dataStore.execute(this.schemaQuery(keyspace)).get()).rows();
        if (row == null) {
            return Collections.emptyList();
        }
        return row.stream().map(r -> this.toSchemaSource(keyspace, (Row)r)).collect(Collectors.toList());
    }

    public SchemaSource getSingleVersion(String keyspace, Optional<UUID> maybeVersion) throws Exception {
        ResultSet resultSet;
        if (!this.tableExists()) {
            return null;
        }
        if (maybeVersion.isPresent()) {
            UUID versionUuid = maybeVersion.get();
            if (versionUuid.version() != 1) {
                return null;
            }
            resultSet = (ResultSet)this.dataStore.execute(this.schemaQueryWithSpecificVersion(keyspace, versionUuid)).get();
        } else {
            resultSet = (ResultSet)this.dataStore.execute(this.schemaQuery(keyspace)).get();
        }
        if (!resultSet.iterator().hasNext()) {
            return null;
        }
        return this.toSchemaSource(keyspace, resultSet.one());
    }

    public SchemaSource getLatestVersion(String keyspace) throws Exception {
        return this.getSingleVersion(keyspace, Optional.empty());
    }

    private SchemaSource toSchemaSource(String keyspace, Row r) {
        return new SchemaSource(keyspace, r.getUuid(VERSION_COLUMN_NAME), r.getString(CONTENTS_COLUMN_NAME));
    }

    @VisibleForTesting
    BoundQuery schemaQueryWithSpecificVersion(String keyspace, UUID uuid) {
        return this.dataStore.queryBuilder().select().column(new String[]{VERSION_COLUMN_NAME, CONTENTS_COLUMN_NAME}).from(KEYSPACE_NAME, TABLE_NAME).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).where(VERSION_COLUMN_NAME, Predicate.EQ, (Object)uuid).build().bind(new Object[0]);
    }

    @VisibleForTesting
    BoundQuery schemaQuery(String keyspace) {
        return this.dataStore.queryBuilder().select().column(new String[]{VERSION_COLUMN_NAME, CONTENTS_COLUMN_NAME}).from(KEYSPACE_NAME, TABLE_NAME).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).orderBy(VERSION_COLUMN_NAME, Column.Order.DESC).build().bind(new Object[0]);
    }

    public SchemaSource insert(String keyspace, String newContents) {
        UUID newVersion = Uuids.timeBased();
        BoundQuery insertNewSchema = this.dataStore.queryBuilder().insertInto(KEYSPACE_NAME, TABLE_NAME).value(KEYSPACE_COLUMN_NAME, (Object)keyspace).value(VERSION_COLUMN_NAME, (Object)newVersion).value(LATEST_VERSION_COLUMN_NAME, (Object)newVersion).value(CONTENTS_COLUMN_NAME, (Object)newContents).value(DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Object)false).build().bind(new Object[0]);
        try {
            this.dataStore.execute(insertNewSchema).get();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Schema deployment for keyspace: %s and version: %s failed.", keyspace, newVersion));
        }
        return new SchemaSource(keyspace, newVersion, newContents);
    }

    private void ensureTableExists() throws Exception {
        if (this.tableExists()) {
            return;
        }
        this.dataStore.execute(this.dataStore.queryBuilder().create().keyspace(KEYSPACE_NAME).ifNotExists().withReplication(KEYSPACE_REPLICATION).build().bind(new Object[0])).get();
        this.dataStore.execute(this.dataStore.queryBuilder().create().table(KEYSPACE_NAME, TABLE_NAME).ifNotExists().column((Collection)EXPECTED_TABLE.columns()).build().bind(new Object[0])).get();
        SchemaSourceDao.failIfUnexpectedSchema(this.dataStore.schema().keyspace(KEYSPACE_NAME).table(TABLE_NAME));
    }

    private boolean tableExists() {
        Keyspace keyspace = this.dataStore.schema().keyspace(KEYSPACE_NAME);
        if (keyspace == null) {
            return false;
        }
        Table table = keyspace.table(TABLE_NAME);
        if (table == null) {
            return false;
        }
        SchemaSourceDao.failIfUnexpectedSchema(table);
        return true;
    }

    private static void failIfUnexpectedSchema(Table table) {
        if (!CassandraSchemaHelper.compare(EXPECTED_TABLE, table).isEmpty()) {
            throw new IllegalStateException(String.format("Table '%s.%s' already exists, but it doesn't have the expected structure", KEYSPACE_NAME, TABLE_NAME));
        }
    }

    public void startDeployment(String keyspace, UUID expectedLatestVersion, boolean force) throws Exception {
        this.ensureTableExists();
        ImmutableList conditions = force ? ImmutableList.of((Object)BuiltCondition.of((String)LATEST_VERSION_COLUMN_NAME, (Predicate)Predicate.EQ, (Object)expectedLatestVersion)) : ImmutableList.of((Object)BuiltCondition.of((String)LATEST_VERSION_COLUMN_NAME, (Predicate)Predicate.EQ, (Object)expectedLatestVersion), (Object)BuiltCondition.of((String)DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Predicate)Predicate.NEQ, (Object)true));
        BoundQuery updateDeploymentToInProgress = this.dataStore.queryBuilder().update(KEYSPACE_NAME, TABLE_NAME).value(DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Object)true).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).ifs((Collection)conditions).build().bind(new Object[0]);
        ResultSet resultSet = (ResultSet)this.dataStore.execute(updateDeploymentToInProgress).get();
        Row row = resultSet.one();
        if (!row.getBoolean(APPLIED_COLUMN_NAME)) {
            this.handleFailedDeployLwt(row, expectedLatestVersion);
        }
    }

    private void handleFailedDeployLwt(Row row, UUID expectedLatestVersion) {
        boolean hasVersion = row.columns().stream().anyMatch(c -> LATEST_VERSION_COLUMN_NAME.equals(c.name()));
        if (!hasVersion) {
            throw new IllegalStateException("You specified expectedVersion but no previous version was found");
        }
        UUID actualLatestVersion = row.getUuid(LATEST_VERSION_COLUMN_NAME);
        if (Objects.equals(actualLatestVersion, expectedLatestVersion)) {
            assert (row.getBoolean(DEPLOYMENT_IN_PROGRESS_COLUMN_NAME));
            throw new IllegalStateException("It looks like someone else is deploying a new schema, please check the latest version and try again. This can also happen if a previous deployment failed unexpectedly, in that case you can use the 'force' argument to bypass this check.");
        }
        throw new IllegalStateException(String.format("You specified expectedVersion %s, but there is a more recent version %s", expectedLatestVersion, actualLatestVersion));
    }

    public void abortDeployment(String keyspace) throws ExecutionException, InterruptedException {
        BoundQuery updateDeploymentToNotInProgress = this.dataStore.queryBuilder().update(KEYSPACE_NAME, TABLE_NAME).value(DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Object)false).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).build().bind(new Object[0]);
        this.dataStore.execute(updateDeploymentToNotInProgress).get();
    }

    public void undeploy(String keyspace, UUID expectedLatestVersion, boolean force) throws ExecutionException, InterruptedException {
        ImmutableList conditions = force ? ImmutableList.of((Object)BuiltCondition.of((String)LATEST_VERSION_COLUMN_NAME, (Predicate)Predicate.EQ, (Object)expectedLatestVersion)) : ImmutableList.of((Object)BuiltCondition.of((String)LATEST_VERSION_COLUMN_NAME, (Predicate)Predicate.EQ, (Object)expectedLatestVersion), (Object)BuiltCondition.of((String)DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Predicate)Predicate.NEQ, (Object)true));
        BoundQuery clearLatestVersion = this.dataStore.queryBuilder().update(KEYSPACE_NAME, TABLE_NAME).value(LATEST_VERSION_COLUMN_NAME, null).value(DEPLOYMENT_IN_PROGRESS_COLUMN_NAME, (Object)false).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).ifs((Collection)conditions).build().bind(new Object[0]);
        Row row = ((ResultSet)this.dataStore.execute(clearLatestVersion).get()).one();
        if (!row.getBoolean(APPLIED_COLUMN_NAME)) {
            this.handleFailedDeployLwt(row, expectedLatestVersion);
        }
    }

    public void purgeOldVersions(String keyspace) throws Exception {
        List<SchemaSource> allSchemasForKeyspace = this.getAllVersions(keyspace);
        int numberOfEntriesToRemove = allSchemasForKeyspace.size() - 10;
        if (numberOfEntriesToRemove > 0) {
            LOGGER.info("Removing {} old schema entries.", (Object)numberOfEntriesToRemove);
            SchemaSource mostRecentToRemove = allSchemasForKeyspace.get(10);
            BoundQuery deleteSchemaQuery = this.dataStore.queryBuilder().delete().from(KEYSPACE_NAME, TABLE_NAME).where(KEYSPACE_COLUMN_NAME, Predicate.EQ, (Object)keyspace).where(VERSION_COLUMN_NAME, Predicate.LTE, (Object)mostRecentToRemove.getVersion()).build().bind(new Object[0]);
            this.dataStore.execute(deleteSchemaQuery).get();
        }
    }

    @VisibleForTesting
    static Replication parseReplication(String spec) {
        if (spec == null) {
            LOGGER.debug("No replication configured, defaulting to {}", (Object)DEFAULT_KEYSPACE_REPLICATION);
            return DEFAULT_KEYSPACE_REPLICATION;
        }
        try {
            Replication replication = spec.matches("\\d+") ? SchemaSourceDao.parseSimpleReplication(spec) : SchemaSourceDao.parseNetworkReplication(spec);
            LOGGER.debug("Using configured replication {}", (Object)replication);
            return replication;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not parse replication '{}' (from {}). Falling back to default {}", new Object[]{spec, KEYSPACE_REPLICATION_PROPERTY, DEFAULT_KEYSPACE_REPLICATION});
            return DEFAULT_KEYSPACE_REPLICATION;
        }
    }

    private static Replication parseSimpleReplication(String spec) {
        int rf = Integer.parseInt(spec);
        if (rf < 1) {
            throw new IllegalArgumentException();
        }
        return Replication.simpleStrategy((int)rf);
    }

    private static Replication parseNetworkReplication(String spec) {
        Map rawOptions = Splitter.on((String)",").withKeyValueSeparator(Splitter.on((String)"=").trimResults()).split((CharSequence)spec);
        LinkedHashMap<String, Integer> options = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : rawOptions.entrySet()) {
            String dc = (String)entry.getKey();
            if (dc.isEmpty()) {
                throw new IllegalArgumentException();
            }
            int rf = Integer.parseInt((String)entry.getValue());
            if (rf < 1) {
                throw new IllegalArgumentException();
            }
            options.put(dc, rf);
        }
        return Replication.networkTopologyStrategy(options);
    }
}

