/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import edu.umd.cs.findbugs.annotations.Nullable;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.cqlfirst.SchemaFactory;
import io.stargate.graphql.schema.graphqlfirst.AdminSchemaBuilder;
import io.stargate.graphql.schema.graphqlfirst.migration.CassandraMigrator;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.graphql.schema.graphqlfirst.processor.SchemaProcessor;
import io.stargate.graphql.web.resources.KeyspaceChangeListener;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlCache
implements KeyspaceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlCache.class);
    private static final boolean DISABLE_DEFAULT_KEYSPACE = Boolean.getBoolean("stargate.graphql.default_keyspace.disabled");
    private final Persistence persistence;
    private final DataStoreFactory dataStoreFactory;
    private final boolean enableGraphqlFirst;
    private final GraphQL ddlGraphql;
    private final GraphQL schemaFirstAdminGraphql;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, GraphqlHolder> dmlGraphqls = new ConcurrentHashMap<String, GraphqlHolder>();

    public GraphqlCache(Persistence persistence, DataStoreFactory dataStoreFactory, boolean enableGraphqlFirst) {
        this.persistence = persistence;
        this.dataStoreFactory = dataStoreFactory;
        this.enableGraphqlFirst = enableGraphqlFirst;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema());
        this.schemaFirstAdminGraphql = GraphQL.newGraphQL((GraphQLSchema)new AdminSchemaBuilder().build()).build();
        this.defaultKeyspace = GraphqlCache.findDefaultKeyspace(dataStoreFactory.createInternal());
        persistence.registerEventListener((EventListener)this);
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getSchemaFirstAdminGraphql() {
        return this.schemaFirstAdminGraphql;
    }

    public GraphQL getDml(String keyspaceName, AuthenticationSubject subject, Map<String, String> headers) throws Exception {
        DataStore dataStore = this.buildUserDatastore(subject, headers);
        SchemaSource latestSource = this.enableGraphqlFirst ? new SchemaSourceDao(dataStore).getLatestVersion(keyspaceName) : null;
        String decoratedKeyspaceName = this.persistence.decorateKeyspaceName(keyspaceName, headers);
        GraphqlHolder currentHolder = (GraphqlHolder)this.dmlGraphqls.get(decoratedKeyspaceName);
        if (currentHolder != null && currentHolder.matches(latestSource)) {
            LOG.trace("Returning cached schema for {}", (Object)decoratedKeyspaceName);
            return currentHolder.getGraphql();
        }
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            LOG.trace("Keyspace {} does not exist", (Object)decoratedKeyspaceName);
            return null;
        }
        LOG.trace("Computing new version for {} ({})", (Object)decoratedKeyspaceName, (Object)(currentHolder == null ? "wasn't cached before" : "schema has changed"));
        GraphqlHolder newHolder = latestSource == null ? new LazyCqlFirstGraphqlHolder(keyspace) : new LazySchemaFirstGraphqlHolder(latestSource, keyspace);
        GraphqlHolder result = this.dmlGraphqls.compute(decoratedKeyspaceName, (__, v) -> Objects.equals(v, currentHolder) ? newHolder : v);
        return result == null ? null : result.getGraphql();
    }

    public void putDml(String keyspaceName, SchemaSource newSource, GraphQL graphql, AuthenticationSubject subject) {
        Map headers = subject.customProperties();
        DataStore dataStore = this.buildUserDatastore(subject, headers);
        String decoratedKeyspaceName = this.persistence.decorateKeyspaceName(keyspaceName, headers);
        LOG.trace("Putting new schema version: {} for {}", (Object)newSource.getVersion(), (Object)decoratedKeyspaceName);
        ImmediateSchemaFirstGraphqlHolder schemaHolder = new ImmediateSchemaFirstGraphqlHolder(newSource, graphql);
        this.dmlGraphqls.put(decoratedKeyspaceName, schemaHolder);
    }

    public String getDefaultKeyspaceName() {
        return this.defaultKeyspace;
    }

    private DataStore buildUserDatastore(AuthenticationSubject subject, Map<String, String> headers) {
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().putAllCustomProperties(headers).build();
        return this.dataStoreFactory.create(subject.asUser(), (DataStoreOptions)dataStoreOptions);
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL((GraphQLSchema)schema).mutationExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        if (DISABLE_DEFAULT_KEYSPACE) {
            return null;
        }
        try {
            CompletableFuture query = dataStore.queryBuilder().select().column("keyspace_name").writeTimeColumn("durable_writes").as("wt").from("system_schema", "keyspaces").build().execute(ConsistencyLevel.LOCAL_QUORUM, new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Optional<Row> first = resultSet.rows().stream().filter(r -> !r.isNull("wt")).filter(r -> r.getLong("wt") > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong("wt")));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    @Override
    @FormatMethod
    public void onKeyspaceChanged(String decoratedKeyspaceName, @FormatString String reason, Object ... reasonArguments) {
        GraphqlHolder holder = (GraphqlHolder)this.dmlGraphqls.get(decoratedKeyspaceName);
        if (holder != null && holder.isCqlFirst() && this.dmlGraphqls.remove(decoratedKeyspaceName) != null && LOG.isDebugEnabled()) {
            LOG.debug("Invalidated GraphQL schema for keyspace {} because {}", (Object)decoratedKeyspaceName, (Object)String.format(reason, reasonArguments));
        }
    }

    static class ImmediateSchemaFirstGraphqlHolder
    implements GraphqlHolder {
        private final SchemaSource source;
        private final GraphQL graphql;

        ImmediateSchemaFirstGraphqlHolder(SchemaSource source, GraphQL graphql) {
            this.source = source;
            this.graphql = graphql;
        }

        @Override
        public GraphQL getGraphql() {
            return this.graphql;
        }

        @Override
        public boolean matches(@Nullable SchemaSource otherSource) {
            return otherSource != null && this.source.getVersion().equals(otherSource.getVersion());
        }

        @Override
        public boolean isCqlFirst() {
            return false;
        }
    }

    class LazySchemaFirstGraphqlHolder
    implements GraphqlHolder {
        private final SchemaSource source;
        private final Supplier<GraphQL> graphqlSupplier;

        LazySchemaFirstGraphqlHolder(SchemaSource source, Keyspace keyspace) {
            this.source = source;
            this.graphqlSupplier = Suppliers.memoize(() -> {
                ProcessedSchema processedSchema = new SchemaProcessor(GraphqlCache.this.persistence, true).process(source.getContents(), keyspace);
                CassandraMigrator.forPersisted().compute(processedSchema.getMappingModel(), keyspace);
                return processedSchema.getGraphql();
            });
        }

        @Override
        public GraphQL getGraphql() {
            return (GraphQL)this.graphqlSupplier.get();
        }

        @Override
        public boolean matches(@Nullable SchemaSource otherSource) {
            return otherSource != null && this.source.getVersion().equals(otherSource.getVersion());
        }

        @Override
        public boolean isCqlFirst() {
            return false;
        }
    }

    static class LazyCqlFirstGraphqlHolder
    implements GraphqlHolder {
        private final Supplier<GraphQL> graphqlSupplier = Suppliers.memoize(() -> GraphqlCache.access$000(SchemaFactory.newDmlSchema(keyspace)));

        LazyCqlFirstGraphqlHolder(Keyspace keyspace) {
        }

        @Override
        public GraphQL getGraphql() {
            return (GraphQL)this.graphqlSupplier.get();
        }

        @Override
        public boolean matches(@Nullable SchemaSource source) {
            return source == null;
        }

        @Override
        public boolean isCqlFirst() {
            return true;
        }
    }

    static interface GraphqlHolder {
        public GraphQL getGraphql();

        public boolean matches(@Nullable SchemaSource var1);

        public boolean isCqlFirst();
    }
}

