/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.UnauthorizedException;
import io.stargate.graphql.web.resources.Authenticated;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@Authenticated
public class AuthenticationFilter
implements ContainerRequestFilter {
    public static final String SUBJECT_KEY = AuthenticationSubject.class.getName();
    private final AuthenticationService authenticationService;

    public AuthenticationFilter(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void filter(ContainerRequestContext context) {
        String token = context.getHeaderString("X-Cassandra-Token");
        try {
            AuthenticationSubject subject = this.authenticationService.validateToken(token, this.deduplicate((MultivaluedMap<String, String>)context.getHeaders()));
            context.setProperty(SUBJECT_KEY, (Object)subject);
        }
        catch (UnauthorizedException e) {
            context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(AuthenticationFilter.buildError("Authentication required", context.getMediaType())).build());
        }
    }

    private Map<String, String> deduplicate(MultivaluedMap<String, String> multimap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : multimap.keySet()) {
            map.put(key, (String)multimap.getFirst((Object)key));
        }
        return map;
    }

    private static Object buildError(String message, MediaType mediaType) {
        return mediaType != null && ("json".equals(mediaType.getSubtype()) || "graphql".equals(mediaType.getSubtype())) ? ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)message)) : message;
    }
}

