/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.graphql.web.RequestToHeadersMapper;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.GraphqlCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class StargateGraphqlContext {
    private final HttpServletRequest request;
    private final AuthenticationSubject subject;
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    private final Persistence persistence;
    private final GraphqlCache graphqlCache;
    private final BatchContext batchContext = new BatchContext();

    public StargateGraphqlContext(HttpServletRequest request, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory, Persistence persistence, GraphqlCache graphqlCache) {
        this.request = request;
        this.subject = (AuthenticationSubject)request.getAttribute(AuthenticationFilter.SUBJECT_KEY);
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
        this.persistence = persistence;
        this.graphqlCache = graphqlCache;
        if (this.subject == null) {
            throw new AssertionError((Object)"Missing authentication subject in the request");
        }
    }

    public AuthenticationSubject getSubject() {
        return this.subject;
    }

    public Map<String, String> getAllHeaders() {
        return RequestToHeadersMapper.getAllHeaders(this.request);
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public GraphqlCache getGraphqlCache() {
        return this.graphqlCache;
    }

    public static class BatchContext {
        private final List<BoundQuery> queries = new ArrayList<BoundQuery>();
        private int operationCount;
        private final CompletableFuture<ResultSet> executionFuture = new CompletableFuture();
        private AtomicReference<DataStore> dataStore = new AtomicReference();

        public CompletableFuture<ResultSet> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<BoundQuery> getQueries() {
            return this.queries;
        }

        public void setExecutionResult(CompletableFuture<ResultSet> result) {
            ((CompletableFuture)result.thenApply(this.executionFuture::complete)).exceptionally(this.executionFuture::completeExceptionally);
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(BoundQuery query) {
            this.queries.add(query);
            ++this.operationCount;
            return this.operationCount;
        }

        public synchronized int add(List<BoundQuery> newQueries) {
            this.queries.addAll(newQueries);
            ++this.operationCount;
            return this.operationCount;
        }

        public boolean setDataStore(DataStore dataStore) {
            return this.dataStore.getAndSet(dataStore) != null;
        }

        public Optional<DataStore> getDataStore() {
            return Optional.ofNullable(this.dataStore.get());
        }
    }
}

