/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionsModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.QueryModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class QueryModelBuilder
extends OperationModelBuilderBase<QueryModel> {
    private final String parentTypeName;

    QueryModelBuilder(FieldDefinition query, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(query, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    QueryModel build() throws SkipException {
        Optional<Directive> cqlSelectDirective = DirectiveHelper.getDirective("cql_select", this.operation);
        Optional<Integer> limit = cqlSelectDirective.flatMap(d -> DirectiveHelper.getIntArgument(d, "limit", this.context));
        Optional<Integer> pageSize = cqlSelectDirective.flatMap(d -> DirectiveHelper.getIntArgument(d, "pageSize", this.context));
        OperationModel.ReturnType returnType = this.getReturnType("Query " + this.operationName);
        EntityModel entity = returnType.getEntity().filter(e -> e.getTarget() == EntityModel.Target.TABLE).orElseThrow(() -> {
            this.invalidMapping("Query %s: return type must reference an entity that maps to a table", this.operationName);
            return SkipException.INSTANCE;
        });
        Optional<String> pagingStateArgumentName = this.findPagingState();
        ConditionsModelBuilder.Conditions conditions = this.buildConditions(entity);
        if (!conditions.getIfConditions().isEmpty()) {
            this.invalidMapping("@cql_if is not supported for select query, but it was set on one of the fields", new Object[0]);
            throw SkipException.INSTANCE;
        }
        List<ConditionModel> whereConditions = conditions.getWhereConditions();
        this.validateNoFiltering(whereConditions, entity);
        return new QueryModel(this.parentTypeName, this.operation, entity, whereConditions, pagingStateArgumentName, limit, pageSize, returnType);
    }

    private Optional<String> findPagingState() throws SkipException {
        Optional<String> result = Optional.empty();
        for (InputValueDefinition inputValue : this.operation.getInputValueDefinitions()) {
            if (!this.isPagingState(inputValue)) continue;
            if (result.isPresent()) {
                this.invalidMapping("Query %s: @cql_pagingState can be used on at most one argument (found %s and %s)", this.operationName, result.get(), inputValue.getName());
                throw SkipException.INSTANCE;
            }
            result = Optional.of(inputValue.getName());
        }
        return result;
    }

    private boolean isPagingState(InputValueDefinition inputValue) throws SkipException {
        boolean hasDirective = DirectiveHelper.getDirective("cql_pagingState", inputValue).isPresent();
        if (!hasDirective) {
            return false;
        }
        Type<?> type = TypeHelper.unwrapNonNull(inputValue.getType());
        if (!(type instanceof TypeName) || !((TypeName)type).getName().equals(Scalars.GraphQLString.getName())) {
            this.invalidMapping("Query %s: argument %s annotated with @cql_pagingState must have type %s", this.operationName, inputValue.getName(), Scalars.GraphQLString.getName());
            throw SkipException.INSTANCE;
        }
        return true;
    }
}

