/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionsModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IfConditionModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.WhereConditionModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;

abstract class OperationModelBuilderBase<T extends OperationModel>
extends ModelBuilderBase<T> {
    protected final FieldDefinition operation;
    protected final String operationName;
    protected final Map<String, EntityModel> entities;
    protected final Map<String, ResponsePayloadModel> responsePayloads;
    private final ConditionsModelBuilder conditionsModelBuilder;

    protected OperationModelBuilderBase(FieldDefinition operation, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(context, operation.getSourceLocation());
        this.operation = operation;
        this.operationName = operation.getName();
        this.entities = entities;
        this.responsePayloads = responsePayloads;
        this.conditionsModelBuilder = new ConditionsModelBuilder((inputValue, e) -> new WhereConditionModelBuilder((InputValueDefinition)inputValue, this.operationName, (EntityModel)e, entities, context), (inputValue, e) -> new IfConditionModelBuilder((InputValueDefinition)inputValue, this.operationName, (EntityModel)e, entities, context), operation, this);
    }

    OperationModel.ReturnType getReturnType(String operationDescription) throws SkipException {
        Type<?> graphqlType = TypeHelper.unwrapNonNull(this.operation.getType());
        if (graphqlType instanceof ListType) {
            EntityModel entity;
            Type<?> elementType = ((ListType)graphqlType).getType();
            if ((elementType = TypeHelper.unwrapNonNull(elementType)) instanceof TypeName && (entity = this.entities.get(((TypeName)elementType).getName())) != null) {
                return new OperationModel.EntityListReturnType(entity);
            }
        } else {
            assert (graphqlType instanceof TypeName);
            String typeName = ((TypeName)graphqlType).getName();
            OperationModel.SimpleReturnType simple = OperationModel.SimpleReturnType.fromTypeName(typeName);
            if (simple != null) {
                return simple;
            }
            EntityModel entity = this.entities.get(typeName);
            if (entity != null) {
                return new OperationModel.EntityReturnType(entity);
            }
            ResponsePayloadModel payload = this.responsePayloads.get(typeName);
            if (payload != null) {
                return payload;
            }
        }
        this.invalidMapping("%s: unsupported return type %s", operationDescription, TypeHelper.format(graphqlType));
        throw SkipException.INSTANCE;
    }

    protected ConditionsModelBuilder.Conditions buildConditions(EntityModel entity) throws SkipException {
        return this.conditionsModelBuilder.build(entity);
    }

    protected void validateNoFiltering(List<ConditionModel> whereConditions, EntityModel entity) throws SkipException {
        Optional<String> maybeError = entity.validateNoFiltering(whereConditions);
        if (maybeError.isPresent()) {
            this.invalidMapping("Operation %s: %s", this.operationName, maybeError.get());
            throw SkipException.INSTANCE;
        }
    }
}

