/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import graphql.language.Directive;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexTarget;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

class IndexModelBuilder
extends ModelBuilderBase<IndexModel> {
    private static final Splitter.MapSplitter OPTIONS_SPLITTER = Splitter.on((char)',').withKeyValueSeparator(Splitter.on((char)':').trimResults(CharMatcher.anyOf((CharSequence)"' ")));
    private static final ImmutableCollectionIndexingType NO_INDEXING_TYPE = ImmutableCollectionIndexingType.builder().build();
    private static final ImmutableCollectionIndexingType VALUES_INDEXING_TYPE = ImmutableCollectionIndexingType.builder().indexValues(true).build();
    private final Directive cqlIndexDirective;
    private final String parentCqlName;
    private final String columnCqlName;
    private final Column.ColumnType cqlType;
    private final String messagePrefix;

    IndexModelBuilder(Directive cqlIndexDirective, String parentCqlName, String columnCqlName, Column.ColumnType cqlType, String messagePrefix, ProcessingContext context) {
        super(context, cqlIndexDirective.getSourceLocation());
        this.cqlIndexDirective = cqlIndexDirective;
        this.parentCqlName = parentCqlName;
        this.columnCqlName = columnCqlName;
        this.cqlType = cqlType;
        this.messagePrefix = messagePrefix;
    }

    @Override
    IndexModel build() throws SkipException {
        String indexName = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "name", this.context).orElse(this.parentCqlName + '_' + this.columnCqlName + "_idx");
        Optional<String> indexClass = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "class", this.context);
        if (!indexClass.isPresent() && !this.context.getPersistence().supportsSecondaryIndex()) {
            if (!this.context.getPersistence().supportsSAI()) {
                this.invalidMapping("%s: the persistence backend does not support regular secondary indexes nor SAI, indexes that don't specify indexClass can't be mapped", this.messagePrefix);
                throw SkipException.INSTANCE;
            }
            this.info("%s: using SAI for index %s because the persistence backend does not support regular secondary indexes", this.messagePrefix, indexName);
            indexClass = Optional.of("org.apache.cassandra.index.sai.StorageAttachedIndex");
        }
        CollectionIndexingType indexingType = DirectiveHelper.getEnumArgument(this.cqlIndexDirective, "target", IndexTarget.class, this.context).filter(this::validateTarget).map(IndexTarget::toIndexingType).orElse((CollectionIndexingType)(this.cqlType.isCollection() ? VALUES_INDEXING_TYPE : NO_INDEXING_TYPE));
        Map<String, String> indexOptions = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "options", this.context).flatMap(this::convertOptions).orElse(Collections.emptyMap());
        if (this.cqlType.isUserDefined() && !this.cqlType.isFrozen()) {
            this.invalidMapping("%s: fields that map to UDTs can only be indexed if they are frozen", this.messagePrefix);
            throw SkipException.INSTANCE;
        }
        return new IndexModel(indexName, indexClass, indexingType, indexOptions);
    }

    private boolean validateTarget(IndexTarget indexTarget) {
        switch (indexTarget) {
            case KEYS: 
            case ENTRIES: {
                if (this.cqlType.isMap()) break;
                this.invalidMapping("%s: index target %s can only be used for map columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            case VALUES: {
                if (this.cqlType.isCollection() && !this.cqlType.isFrozen()) break;
                this.invalidMapping("%s: index target %s can only be used for non-frozen collection columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            case FULL: {
                if (this.cqlType.isCollection() && this.cqlType.isFrozen()) break;
                this.invalidMapping("%s: index target %s can only be used for frozen collection columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            default: {
                throw new AssertionError((Object)("Unsupported target " + (Object)((Object)indexTarget)));
            }
        }
        return true;
    }

    private Optional<Map<String, String>> convertOptions(String rawOptions) {
        try {
            return Optional.of(OPTIONS_SPLITTER.split((CharSequence)rawOptions));
        }
        catch (IllegalArgumentException e) {
            this.invalidMapping("%s: invalid format for options. Expected 'option1':'value1','option2','value2'...", this.messagePrefix);
            return Optional.empty();
        }
    }
}

