/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableSecondaryIndex;
import io.stargate.db.schema.ImmutableTable;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityModelBuilder
extends ModelBuilderBase<EntityModel> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityModelBuilder.class);
    private static final Pattern NON_NESTED_FIELDS = Pattern.compile("[_A-Za-z][_0-9A-Za-z]*(?:\\s+[_A-Za-z][_0-9A-Za-z]*)*");
    private static final Splitter ON_SPACES = Splitter.onPattern((String)"\\s+");
    private final ObjectTypeDefinition type;
    private final String graphqlName;

    EntityModelBuilder(ObjectTypeDefinition type, ProcessingContext context) {
        super(context, type.getSourceLocation());
        this.type = type;
        this.graphqlName = type.getName();
    }

    @Override
    EntityModel build() throws SkipException {
        UserDefinedType udtCqlSchema;
        Table tableCqlSchema;
        Optional<Directive> cqlEntityDirective = DirectiveHelper.getDirective("cql_entity", this.type);
        String cqlName = this.providedCqlNameOrDefault(cqlEntityDirective);
        EntityModel.Target target = this.providedTargetOrDefault(cqlEntityDirective);
        Optional<String> inputTypeName = DirectiveHelper.getDirective("cql_input", this.type).map(this::providedInputNameOrDefault);
        ArrayList<FieldModel> partitionKey = new ArrayList<FieldModel>();
        ArrayList<FieldModel> clusteringColumns = new ArrayList<FieldModel>();
        ArrayList<FieldModel> regularColumns = new ArrayList<FieldModel>();
        for (FieldDefinition fieldDefinition : this.type.getFieldDefinitions()) {
            try {
                FieldModel fieldMapping = new FieldModelBuilder(fieldDefinition, this.context, cqlName, this.graphqlName, target, inputTypeName.isPresent()).build();
                if (fieldMapping.isPartitionKey()) {
                    partitionKey.add(fieldMapping);
                    continue;
                }
                if (fieldMapping.getClusteringOrder().isPresent()) {
                    clusteringColumns.add(fieldMapping);
                    continue;
                }
                regularColumns.add(fieldMapping);
            }
            catch (SkipException e) {
                LOG.debug("Skipping field {} because it has mapping errors, this will be reported after the whole schema has been processed.", (Object)fieldDefinition.getName());
            }
        }
        switch (target) {
            case TABLE: {
                if (!this.hasPartitionKey(partitionKey, regularColumns)) {
                    this.invalidMapping("%s must have at least one partition key field (use scalar type ID, Uuid or TimeUuid for the first field, or annotate your fields with @cql_column(partitionKey: true))", new Object[]{this.graphqlName});
                    throw SkipException.INSTANCE;
                }
                tableCqlSchema = EntityModelBuilder.buildCqlTable(this.context.getKeyspace().name(), cqlName, partitionKey, clusteringColumns, regularColumns);
                udtCqlSchema = null;
                break;
            }
            case UDT: {
                if (regularColumns.isEmpty()) {
                    this.invalidMapping("%s must have at least one field", new Object[]{this.graphqlName});
                    throw SkipException.INSTANCE;
                }
                tableCqlSchema = null;
                udtCqlSchema = EntityModelBuilder.buildCqlUdt(this.context.getKeyspace().name(), cqlName, regularColumns);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected target " + (Object)((Object)target)));
            }
        }
        return new EntityModel(this.graphqlName, this.context.getKeyspace().name(), cqlName, target, partitionKey, clusteringColumns, regularColumns, tableCqlSchema, udtCqlSchema, this.isFederated(partitionKey, clusteringColumns, target), inputTypeName);
    }

    private String providedCqlNameOrDefault(Optional<Directive> cqlEntityDirective) {
        return cqlEntityDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "name", this.context)).orElse(this.graphqlName);
    }

    private EntityModel.Target providedTargetOrDefault(Optional<Directive> cqlEntityDirective) {
        return cqlEntityDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "target", EntityModel.Target.class, this.context)).orElse(EntityModel.Target.TABLE);
    }

    private String providedInputNameOrDefault(Directive cqlInputDirective) {
        Optional<String> maybeName = DirectiveHelper.getStringArgument(cqlInputDirective, "name", this.context);
        if (maybeName.isPresent()) {
            return maybeName.get();
        }
        this.info("%1$s: using '%1$sInput' as the input type name since @cql_input doesn't have an argument", this.graphqlName);
        return this.graphqlName + "Input";
    }

    private boolean hasPartitionKey(List<FieldModel> partitionKey, List<FieldModel> regularColumns) {
        if (!partitionKey.isEmpty()) {
            return true;
        }
        FieldModel firstField = regularColumns.get(0);
        if (TypeHelper.mapsToUuid(firstField.getGraphqlType())) {
            this.info("%s: using %s as the partition key, because it has type %s and no other fields are annotated", this.graphqlName, firstField.getGraphqlName(), TypeHelper.format(TypeHelper.unwrapNonNull(firstField.getGraphqlType())));
            partitionKey.add(firstField.asPartitionKey());
            regularColumns.remove(firstField);
            return true;
        }
        return false;
    }

    private boolean isFederated(List<FieldModel> partitionKey, List<FieldModel> clusteringColumns, EntityModel.Target target) throws SkipException {
        List keyDirectives = this.type.getDirectives("key");
        if (keyDirectives.isEmpty()) {
            return false;
        }
        if (target == EntityModel.Target.UDT) {
            this.invalidMapping("%s: can't use @key directive because this type maps to a UDT", new Object[]{this.graphqlName});
            throw SkipException.INSTANCE;
        }
        if (keyDirectives.size() > 1) {
            this.invalidMapping("%s: this implementation only supports a single @key directive", new Object[]{this.graphqlName});
            throw SkipException.INSTANCE;
        }
        Directive keyDirective = (Directive)keyDirectives.get(0);
        Optional<String> fieldsArgument = DirectiveHelper.getStringArgument(keyDirective, "fields", this.context);
        if (fieldsArgument.isPresent()) {
            Set primaryKeyFields;
            String value = fieldsArgument.get();
            if (!NON_NESTED_FIELDS.matcher(value).matches()) {
                this.invalidMapping("%s: could not parse @key.fields (this implementation only supports top-level fields as key components)", new Object[]{this.graphqlName});
                throw SkipException.INSTANCE;
            }
            ImmutableSet directiveFields = ImmutableSet.copyOf((Iterable)ON_SPACES.split((CharSequence)value));
            if (!directiveFields.equals(primaryKeyFields = Stream.concat(partitionKey.stream(), clusteringColumns.stream()).map(FieldModel::getGraphqlName).collect(Collectors.toSet()))) {
                this.invalidMapping("%s: @key.fields doesn't match the partition and clustering keys (expected %s)", new Object[]{this.graphqlName, primaryKeyFields});
                throw SkipException.INSTANCE;
            }
        }
        return true;
    }

    private static Table buildCqlTable(String keyspaceName, String tableName, List<FieldModel> partitionKey, List<FieldModel> clusteringColumns, List<FieldModel> regularColumns) {
        ImmutableList.Builder columnMetadatas = ImmutableList.builder();
        ImmutableList.Builder indexes = ImmutableList.builder();
        for (FieldModel field2 : regularColumns) {
            ImmutableColumn column = EntityModelBuilder.cqlColumnBuilder(keyspaceName, tableName, field2).kind(Column.Kind.Regular).build();
            columnMetadatas.add((Object)column);
            field2.getIndex().ifPresent(arg_0 -> EntityModelBuilder.lambda$buildCqlTable$2(keyspaceName, (Column)column, indexes, arg_0));
        }
        return ImmutableTable.builder().keyspace(keyspaceName).name(tableName).addAllColumns((Iterable)partitionKey.stream().map(field -> EntityModelBuilder.cqlColumnBuilder(keyspaceName, tableName, field).kind(Column.Kind.PartitionKey).build()).collect(Collectors.toList())).addAllColumns((Iterable)clusteringColumns.stream().map(field -> {
            assert (field.getClusteringOrder().isPresent());
            return EntityModelBuilder.cqlColumnBuilder(keyspaceName, tableName, field).kind(Column.Kind.Clustering).order(field.getClusteringOrder().get()).build();
        }).collect(Collectors.toList())).addAllColumns((Iterable)columnMetadatas.build()).addAllIndexes((Iterable)indexes.build()).build();
    }

    private static UserDefinedType buildCqlUdt(String keyspaceName, String tableName, List<FieldModel> regularColumns) {
        return ImmutableUserDefinedType.builder().keyspace(keyspaceName).name(tableName).columns((Iterable)regularColumns.stream().map(field -> EntityModelBuilder.cqlColumnBuilder(keyspaceName, tableName, field).kind(Column.Kind.Regular).build()).collect(Collectors.toList())).build();
    }

    private static ImmutableColumn.Builder cqlColumnBuilder(String keyspaceName, String cqlName, FieldModel field) {
        return ImmutableColumn.builder().keyspace(keyspaceName).table(cqlName).name(field.getCqlName()).type(field.getCqlType());
    }

    private static /* synthetic */ void lambda$buildCqlTable$2(String keyspaceName, Column column, ImmutableList.Builder indexes, IndexModel index) {
        ImmutableSecondaryIndex.Builder builder = ImmutableSecondaryIndex.builder().keyspace(keyspaceName).column(column).name(index.getName()).indexingClass((String)index.getIndexClass().orElse(null)).indexingType(index.getIndexingType()).putAllIndexingOptions(index.getOptions());
        indexes.add((Object)builder.build());
    }
}

