/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableList;
import io.stargate.db.query.Predicate;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntityModel {
    private final String graphqlName;
    private final String keyspaceName;
    private final String cqlName;
    private final Target target;
    private final List<FieldModel> partitionKey;
    private final List<FieldModel> clusteringColumns;
    private final List<FieldModel> primaryKey;
    private final List<ConditionModel> primaryKeyWhereConditions;
    private final List<FieldModel> regularColumns;
    private final List<FieldModel> allColumns;
    private final Table tableCqlSchema;
    private final UserDefinedType udtCqlSchema;
    private final boolean isFederated;
    private final Optional<String> inputTypeName;

    EntityModel(String graphqlName, String keyspaceName, String cqlName, Target target, List<FieldModel> partitionKey, List<FieldModel> clusteringColumns, List<FieldModel> regularColumns, Table tableCqlSchema, UserDefinedType udtCqlSchema, boolean isFederated, Optional<String> inputTypeName) {
        assert (target == Target.TABLE && tableCqlSchema != null && udtCqlSchema == null || target == Target.UDT && tableCqlSchema == null && udtCqlSchema != null);
        this.graphqlName = graphqlName;
        this.keyspaceName = keyspaceName;
        this.cqlName = cqlName;
        this.target = target;
        this.partitionKey = ImmutableList.copyOf(partitionKey);
        this.clusteringColumns = ImmutableList.copyOf(clusteringColumns);
        this.primaryKey = ImmutableList.builder().addAll(partitionKey).addAll(clusteringColumns).build();
        this.primaryKeyWhereConditions = this.primaryKey.stream().map(field -> new ConditionModel((FieldModel)field, Predicate.EQ, field.getGraphqlName())).collect(Collectors.toList());
        this.regularColumns = ImmutableList.copyOf(regularColumns);
        this.allColumns = ImmutableList.builder().addAll(this.primaryKey).addAll(regularColumns).build();
        this.tableCqlSchema = tableCqlSchema;
        this.udtCqlSchema = udtCqlSchema;
        this.isFederated = isFederated;
        this.inputTypeName = inputTypeName;
    }

    public String getGraphqlName() {
        return this.graphqlName;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getCqlName() {
        return this.cqlName;
    }

    public Target getTarget() {
        return this.target;
    }

    public List<FieldModel> getPartitionKey() {
        return this.partitionKey;
    }

    public List<FieldModel> getClusteringColumns() {
        return this.clusteringColumns;
    }

    public List<FieldModel> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ConditionModel> getPrimaryKeyWhereConditions() {
        return this.primaryKeyWhereConditions;
    }

    public List<FieldModel> getRegularColumns() {
        return this.regularColumns;
    }

    public List<FieldModel> getAllColumns() {
        return this.allColumns;
    }

    public Table getTableCqlSchema() {
        if (this.target != Target.TABLE) {
            throw new UnsupportedOperationException("Can't call this method when target = " + (Object)((Object)this.target));
        }
        return this.tableCqlSchema;
    }

    public UserDefinedType getUdtCqlSchema() {
        if (this.target != Target.UDT) {
            throw new UnsupportedOperationException("Can't call this method when target = " + (Object)((Object)this.target));
        }
        return this.udtCqlSchema;
    }

    public boolean isFederated() {
        return this.isFederated;
    }

    public Optional<String> getInputTypeName() {
        return this.inputTypeName;
    }

    public Optional<String> validateNoFiltering(Collection<ConditionModel> conditions) {
        long indexCount = conditions.stream().filter(c -> !c.getField().isPrimaryKey()).count();
        if (indexCount == 0L) {
            return this.validateNoFilteringWhenNoIndex(conditions);
        }
        if (indexCount == 1L) {
            return this.validateNoFilteringWhenOneIndex(conditions);
        }
        return Optional.of("cannot use more than one indexed field per operation");
    }

    private Optional<String> validateNoFilteringWhenNoIndex(Collection<ConditionModel> conditions) {
        for (FieldModel field : this.getPartitionKey()) {
            if (!conditions.stream().noneMatch(c -> c.getField().equals(field))) continue;
            return Optional.of(String.format("every partition key field of type %s must be present (expected: %s).", this.getGraphqlName(), this.describePartitionKey()));
        }
        String firstNonEqField = null;
        for (FieldModel field : this.getClusteringColumns()) {
            Optional<ConditionModel> maybeCondition = conditions.stream().filter(c -> c.getField().equals(field)).findFirst();
            if (!maybeCondition.isPresent()) {
                if (firstNonEqField != null) continue;
                firstNonEqField = field.getGraphqlName();
                continue;
            }
            if (firstNonEqField != null) {
                return Optional.of(String.format("clustering field %s is not restricted by EQ or IN, so no other clustering field after it can be restricted (offending: %s).", firstNonEqField, field.getGraphqlName()));
            }
            Predicate predicate = maybeCondition.get().getPredicate();
            if (predicate == Predicate.EQ || predicate == Predicate.IN) continue;
            firstNonEqField = field.getGraphqlName();
        }
        return Optional.empty();
    }

    private Optional<String> validateNoFilteringWhenOneIndex(Collection<ConditionModel> conditions) {
        if (conditions.stream().anyMatch(c -> c.getField().isClusteringColumn())) {
            return Optional.of("when an indexed field is present, no clustering field can be used");
        }
        long partitionKeyCount = this.getPartitionKey().stream().filter(field -> conditions.stream().anyMatch(c -> c.getField().equals(field))).count();
        if (partitionKeyCount > 0L && partitionKeyCount != (long)this.getPartitionKey().size()) {
            return Optional.of(String.format("when an indexed field is present, either none or all of the partition key fields must be present (expected %s).", this.describePartitionKey()));
        }
        return Optional.empty();
    }

    private String describePartitionKey() {
        return this.getPartitionKey().stream().map(FieldModel::getGraphqlName).collect(Collectors.joining(", "));
    }

    public String toString() {
        return "EntityMappingModel{graphqlName='" + this.graphqlName + '\'' + ", keyspaceName='" + this.keyspaceName + '\'' + ", cqlName='" + this.cqlName + '\'' + ", target=" + (Object)((Object)this.target) + ", partitionKey=" + this.partitionKey + ", clusteringColumns=" + this.clusteringColumns + ", primaryKey=" + this.primaryKey + ", regularColumns=" + this.regularColumns + ", allColumns=" + this.allColumns + ", tableCqlSchema=" + this.tableCqlSchema + ", udtCqlSchema=" + this.udtCqlSchema + ", isFederated=" + this.isFederated + ", inputTypeName=" + this.inputTypeName + '}';
    }

    public static enum Target {
        TABLE,
        UDT;

    }
}

