/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionsModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.DeleteModel;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class DeleteModelBuilder
extends MutationModelBuilder {
    private final String parentTypeName;

    DeleteModelBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(mutation, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    MutationModel build() throws SkipException {
        List<ConditionModel> ifConditions;
        List<ConditionModel> whereConditions;
        EntityModel entity;
        List arguments;
        Optional<Directive> cqlDeleteDirective = DirectiveHelper.getDirective("cql_delete", this.operation);
        boolean ifExists = this.computeIfExists(cqlDeleteDirective);
        OperationModel.ReturnType returnType = this.getReturnType("Mutation " + this.operationName);
        if (returnType != OperationModel.SimpleReturnType.BOOLEAN && !(returnType instanceof ResponsePayloadModel)) {
            this.invalidMapping("Mutation %s: invalid return type. Expected Boolean or a response payload", this.operationName);
            throw SkipException.INSTANCE;
        }
        if (returnType instanceof ResponsePayloadModel) {
            ResponsePayloadModel payload = (ResponsePayloadModel)returnType;
            Set unsupportedFields = payload.getTechnicalFields().stream().filter(f -> f != ResponsePayloadModel.TechnicalField.APPLIED).map(ResponsePayloadModel.TechnicalField::getGraphqlName).collect(Collectors.toCollection(HashSet::new));
            payload.getEntityField().ifPresent(e -> unsupportedFields.add(e.getName()));
            if (!unsupportedFields.isEmpty()) {
                this.warn("Mutation %s: 'applied' is the only supported field in delete response payloads. Others will always be null (%s).", this.operationName, String.join((CharSequence)", ", unsupportedFields));
            }
        }
        if ((arguments = this.operation.getInputValueDefinitions()).isEmpty()) {
            this.invalidMapping("Mutation %s: deletes must take either the entity input type or a list of primary key fields", this.operationName);
            throw SkipException.INSTANCE;
        }
        InputValueDefinition firstArgument = (InputValueDefinition)arguments.get(0);
        Optional<EntityModel> entityFromFirstArgument = this.findEntity(firstArgument);
        Optional<String> entityArgumentName = entityFromFirstArgument.map(__ -> firstArgument.getName());
        if (entityFromFirstArgument.isPresent()) {
            if (arguments.size() > 1) {
                this.invalidMapping("Mutation %s: if a delete takes an entity input type, it must be the only argument", this.operationName);
                throw SkipException.INSTANCE;
            }
            entity = entityFromFirstArgument.get();
            whereConditions = entity.getPrimaryKeyWhereConditions();
            ifConditions = Collections.emptyList();
        } else {
            entity = this.entityFromDirective(cqlDeleteDirective);
            ConditionsModelBuilder.Conditions conditions = this.buildConditions(entity);
            whereConditions = conditions.getWhereConditions();
            ifConditions = conditions.getIfConditions();
            this.validateNoFiltering(whereConditions, entity);
        }
        return new DeleteModel(this.parentTypeName, this.operation, entity, entityArgumentName, whereConditions, ifConditions, returnType, ifExists);
    }

    private boolean computeIfExists(Optional<Directive> cqlDeleteDirective) {
        return cqlDeleteDirective.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "ifExists", this.context)).orElseGet(() -> {
            if (this.operation.getName().endsWith("IfExists")) {
                this.info("Mutation %s: setting the 'ifExists' flag implicitly because the name follows the naming convention.", this.operationName);
                return true;
            }
            return false;
        });
    }

    private EntityModel entityFromDirective(Optional<Directive> cqlDeleteDirective) throws SkipException {
        String entityName = (String)cqlDeleteDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "targetEntity", this.context)).orElseThrow(() -> {
            this.invalidMapping("Mutation %s: if a delete doesn't take an entity input type, it must indicate the entity name in '@cql_delete.targetEntity'", this.operationName);
            return SkipException.INSTANCE;
        });
        EntityModel entity = (EntityModel)this.entities.get(entityName);
        if (entity == null) {
            this.invalidMapping("Mutation %s: unknown entity %s (from '@cql_delete.targetEntity')", this.operationName, entityName);
            throw SkipException.INSTANCE;
        }
        return entity;
    }
}

