/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableList;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.InvalidMappingReporter;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.List;
import java.util.function.BiFunction;

public class ConditionsModelBuilder {
    public static final String CQL_WHERE = "cql_where";
    public static final String CQL_IF = "cql_if";
    private final BiFunction<InputValueDefinition, EntityModel, ModelBuilderBase<ConditionModel>> whereConditionModelBuilder;
    private final BiFunction<InputValueDefinition, EntityModel, ModelBuilderBase<ConditionModel>> ifConditionModelBuilder;
    private final FieldDefinition operation;
    private final InvalidMappingReporter invalidMappingReporter;

    public ConditionsModelBuilder(BiFunction<InputValueDefinition, EntityModel, ModelBuilderBase<ConditionModel>> whereConditionModelBuilder, BiFunction<InputValueDefinition, EntityModel, ModelBuilderBase<ConditionModel>> ifConditionModelBuilder, FieldDefinition operation, InvalidMappingReporter invalidMappingReporter) {
        this.whereConditionModelBuilder = whereConditionModelBuilder;
        this.ifConditionModelBuilder = ifConditionModelBuilder;
        this.operation = operation;
        this.invalidMappingReporter = invalidMappingReporter;
    }

    public Conditions build(EntityModel entity) throws SkipException {
        ImmutableList.Builder ifConditionsBuilder = ImmutableList.builder();
        ImmutableList.Builder whereConditionsBuilder = ImmutableList.builder();
        boolean foundErrors = false;
        for (InputValueDefinition inputValue : this.operation.getInputValueDefinitions()) {
            if (this.isCqlIfDirective(inputValue) && this.isCqlWhereDirective(inputValue)) {
                this.invalidMappingReporter.invalidMapping("You cannot set both: %s and %s directives on the same field: %s", CQL_IF, CQL_WHERE, inputValue.getName());
                foundErrors = true;
            }
            if (DirectiveHelper.getDirective("cql_pagingState", inputValue).isPresent()) continue;
            try {
                if (this.isCqlIfDirective(inputValue)) {
                    ifConditionsBuilder.add((Object)this.ifConditionModelBuilder.apply(inputValue, entity).build());
                    continue;
                }
                whereConditionsBuilder.add((Object)this.whereConditionModelBuilder.apply(inputValue, entity).build());
            }
            catch (SkipException __) {
                foundErrors = true;
            }
        }
        if (foundErrors) {
            throw SkipException.INSTANCE;
        }
        return new Conditions((List<ConditionModel>)ifConditionsBuilder.build(), (List<ConditionModel>)whereConditionsBuilder.build());
    }

    private boolean isCqlWhereDirective(InputValueDefinition inputValue) {
        return DirectiveHelper.getDirective(CQL_WHERE, inputValue).isPresent();
    }

    private boolean isCqlIfDirective(InputValueDefinition inputValue) {
        return DirectiveHelper.getDirective(CQL_IF, inputValue).isPresent();
    }

    public static class Conditions {
        private final List<ConditionModel> ifConditions;
        private final List<ConditionModel> whereConditions;

        public Conditions(List<ConditionModel> ifConditions, List<ConditionModel> whereConditions) {
            this.ifConditions = ifConditions;
            this.whereConditions = whereConditions;
        }

        public List<ConditionModel> getIfConditions() {
            return this.ifConditions;
        }

        public List<ConditionModel> getWhereConditions() {
            return this.whereConditions;
        }
    }
}

