/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.Type;
import io.stargate.db.query.Predicate;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.Map;
import java.util.Optional;

public abstract class ConditionModelBuilderBase
extends ModelBuilderBase<ConditionModel> {
    protected final InputValueDefinition argument;
    protected final String operationName;
    protected final EntityModel entity;
    protected final Map<String, EntityModel> entities;

    protected ConditionModelBuilderBase(ProcessingContext context, InputValueDefinition argument, String operationName, EntityModel entity, Map<String, EntityModel> entities) {
        super(context, argument.getSourceLocation());
        this.argument = argument;
        this.operationName = operationName;
        this.entity = entity;
        this.entities = entities;
    }

    @Override
    protected ConditionModel build() throws SkipException {
        Optional<Directive> directive = DirectiveHelper.getDirective(this.getDirectiveName(), this.argument);
        String fieldName = directive.flatMap(d -> DirectiveHelper.getStringArgument(d, "field", this.context)).orElse(this.argument.getName());
        Predicate predicate = directive.flatMap(d -> DirectiveHelper.getEnumArgument(d, "predicate", Predicate.class, this.context)).orElse(Predicate.EQ);
        FieldModel field = this.findField(fieldName);
        this.validate(field, predicate);
        return new ConditionModel(field, predicate, this.argument.getName());
    }

    protected void checkArgumentIsSameAs(FieldModel field) throws SkipException {
        Type<?> fieldInputType;
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        if (!argumentType.isEqualTo(fieldInputType = this.toInput(field.getGraphqlType(), this.argument, this.entity, field))) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match %s.%s", new Object[]{this.operationName, this.argument.getName(), TypeHelper.format(fieldInputType), this.entity.getGraphqlName(), field.getGraphqlName()});
            throw SkipException.INSTANCE;
        }
    }

    protected Type<?> toInput(Type<?> fieldType, InputValueDefinition inputValue, EntityModel entity, FieldModel field) throws SkipException {
        try {
            return TypeHelper.toInput(TypeHelper.unwrapNonNull(fieldType), this.entities);
        }
        catch (IllegalArgumentException e) {
            this.invalidMapping("Operation %s: can't infer expected input type for %s (matching %s.%s) because %s", new Object[]{this.operationName, inputValue.getName(), entity.getGraphqlName(), field.getGraphqlName(), e.getMessage()});
            throw SkipException.INSTANCE;
        }
    }

    protected FieldModel findField(String fieldName) throws SkipException {
        return this.entity.getAllColumns().stream().filter(f -> f.getGraphqlName().equals(fieldName)).findFirst().orElseThrow(() -> {
            this.invalidMapping("Operation %s: could not find field %s in type %s", new Object[]{this.operationName, fieldName, this.entity.getGraphqlName()});
            return SkipException.INSTANCE;
        });
    }

    protected abstract String getDirectiveName();

    protected abstract void validate(FieldModel var1, Predicate var2) throws SkipException;

    protected void checkArgumentIsListOf(FieldModel field) throws SkipException {
        Type<?> fieldInputType;
        ListType expectedArgumentType;
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        if (!argumentType.isEqualTo((Node)(expectedArgumentType = ListType.newListType(fieldInputType = this.toInput(field.getGraphqlType(), this.argument, this.entity, field)).build()))) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match %s.%s", new Object[]{this.operationName, this.argument.getName(), TypeHelper.format(expectedArgumentType), this.entity.getGraphqlName(), field.getGraphqlName()});
        }
    }
}

