/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import com.google.common.collect.ImmutableList;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateIndexQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;
import java.util.Collection;
import java.util.List;

public class CreateTableQuery
extends MigrationQuery {
    private final Table table;

    public static List<MigrationQuery> createTableAndIndexes(Table table) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new CreateTableQuery(table));
        for (Index index : table.indexes()) {
            if (!(index instanceof SecondaryIndex)) continue;
            builder.add((Object)new CreateIndexQuery(table, (SecondaryIndex)index));
        }
        return builder.build();
    }

    public CreateTableQuery(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().create().table(this.table.keyspace(), this.table.name()).column((Collection)this.table.columns()).build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return "Create table " + this.table.name();
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.table.keyspace(), this.table.name(), Scope.CREATE, SourceAPI.GRAPHQL, ResourceKind.TABLE);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return that instanceof CreateIndexQuery && ((CreateIndexQuery)that).getTable().name().equals(this.table.name());
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.table.columns().stream().anyMatch(c -> this.references(c.type(), udtName));
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

