/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.UpdateModel;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateFetcher
extends DeployedFetcher<Boolean> {
    private final UpdateModel model;

    public UpdateFetcher(UpdateModel model, MappingModel mappingModel) {
        super(mappingModel);
        this.model = model;
    }

    @Override
    protected Boolean get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        EntityModel entityModel = this.model.getEntity();
        Keyspace keyspace = dataStore.schema().keyspace(entityModel.getKeyspaceName());
        Map input = (Map)environment.getArgument(this.model.getEntityArgumentName());
        List<BuiltCondition> whereConditions = this.bindWhere(entityModel.getPrimaryKeyWhereConditions(), entityModel, input::containsKey, input::get, keyspace);
        ArrayList<ValueModifier> modifiers = new ArrayList<ValueModifier>();
        for (FieldModel column : entityModel.getRegularColumns()) {
            String graphqlName = column.getGraphqlName();
            if (!input.containsKey(graphqlName)) continue;
            Object graphqlValue = input.get(graphqlName);
            modifiers.add(ValueModifier.set((String)column.getCqlName(), (Object)this.toCqlValue(graphqlValue, column.getCqlType(), keyspace)));
        }
        if (modifiers.isEmpty()) {
            throw new IllegalArgumentException("Input object must have at least one non-PK field set for an update");
        }
        AbstractBound query = (AbstractBound)dataStore.queryBuilder().update(entityModel.getKeyspaceName(), entityModel.getCqlName()).value(modifiers).where(whereConditions).build().bind(new Object[0]);
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), entityModel.getKeyspaceName(), entityModel.getCqlName(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY, SourceAPI.GRAPHQL);
        this.executeUnchecked(query, Optional.empty(), Optional.empty(), dataStore);
        return true;
    }
}

