/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.Coercing;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.QueryModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.scalars.CqlScalar;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class QueryFetcher
extends DeployedFetcher<Object> {
    private static final Coercing<ByteBuffer, String> BLOB_COERCING = CqlScalar.BLOB.getGraphqlType().getCoercing();
    private final QueryModel model;

    public QueryFetcher(QueryModel model, MappingModel mappingModel) {
        super(mappingModel);
        this.model = model;
    }

    @Override
    protected Object get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        Object entityData;
        Keyspace keyspace = dataStore.schema().keyspace(this.model.getEntity().getKeyspaceName());
        Optional<ByteBuffer> pagingState = this.model.getPagingStateArgumentName().filter(arg_0 -> ((DataFetchingEnvironment)environment).containsArgument(arg_0)).map(name -> (ByteBuffer)BLOB_COERCING.parseValue(environment.getArgument(name)));
        OperationModel.ReturnType returnType = this.model.getReturnType();
        List<BuiltCondition> whereConditions = this.bindWhere(this.model.getWhereConditions(), this.model.getEntity(), arg_0 -> ((DataFetchingEnvironment)environment).containsArgument(arg_0), arg_0 -> ((DataFetchingEnvironment)environment).getArgument(arg_0), keyspace);
        ResultSet resultSet = this.query(this.model.getEntity(), whereConditions, pagingState, this.model.getLimit(), this.model.getPageSize(), dataStore, (StargateGraphqlContext)environment.getContext());
        Object object = entityData = returnType.isEntityList() ? this.toEntities(resultSet, this.model.getEntity()) : this.toSingleEntity(resultSet, this.model.getEntity());
        if (returnType instanceof ResponsePayloadModel) {
            ByteBuffer nextPagingState;
            ResponsePayloadModel payloadModel = (ResponsePayloadModel)returnType;
            assert (payloadModel.getEntityField().isPresent());
            String entityFieldName = payloadModel.getEntityField().get().getName();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(entityFieldName, entityData);
            if (payloadModel.getTechnicalFields().contains((Object)ResponsePayloadModel.TechnicalField.PAGING_STATE) && (nextPagingState = resultSet.getPagingState()) != null) {
                response.put(ResponsePayloadModel.TechnicalField.PAGING_STATE.getGraphqlName(), BLOB_COERCING.serialize((Object)nextPagingState));
            }
            return response;
        }
        return entityData;
    }
}

