/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.InsertModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.graphql.schema.graphqlfirst.util.Uuids;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class InsertFetcher
extends DeployedFetcher<Map<String, Object>> {
    private final InsertModel model;

    public InsertFetcher(InsertModel model, MappingModel mappingModel) {
        super(mappingModel);
        this.model = model;
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        boolean applied;
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        EntityModel entityModel = this.model.getEntity();
        boolean isLwt = this.model.ifNotExists();
        Keyspace keyspace = dataStore.schema().keyspace(entityModel.getKeyspaceName());
        Map input = (Map)environment.getArgument(this.model.getEntityArgumentName());
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        ArrayList<ValueModifier> setters = new ArrayList<ValueModifier>();
        for (FieldModel column : entityModel.getAllColumns()) {
            Object cqlValue;
            Object graphqlValue;
            String graphqlName = column.getGraphqlName();
            if (input.containsKey(graphqlName)) {
                graphqlValue = input.get(graphqlName);
                cqlValue = this.toCqlValue(graphqlValue, column.getCqlType(), keyspace);
            } else {
                if (!column.isPrimaryKey()) continue;
                if (TypeHelper.mapsToUuid(column.getGraphqlType())) {
                    cqlValue = this.generateUuid(column.getCqlType());
                    graphqlValue = cqlValue.toString();
                } else {
                    throw new IllegalArgumentException("Missing value for field " + graphqlName);
                }
            }
            setters.add(ValueModifier.set((String)column.getCqlName(), (Object)cqlValue));
            this.writeEntityField(graphqlName, graphqlValue, selectionSet, response);
        }
        AbstractBound query = (AbstractBound)dataStore.queryBuilder().insertInto(entityModel.getKeyspaceName(), entityModel.getCqlName()).value(setters).ifNotExists(isLwt).build().bind(new Object[0]);
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), entityModel.getKeyspaceName(), entityModel.getCqlName(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY, SourceAPI.GRAPHQL);
        ResultSet resultSet = this.executeUnchecked(query, Optional.empty(), Optional.empty(), dataStore);
        if (isLwt) {
            Row row = resultSet.one();
            applied = row.getBoolean("[applied]");
            if (!applied) {
                for (FieldModel field : this.model.getEntity().getAllColumns()) {
                    if (row.columns().stream().noneMatch(c -> c.name().equals(field.getCqlName()))) continue;
                    Object cqlValue = row.getObject(field.getCqlName());
                    this.writeEntityField(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()), selectionSet, response);
                }
            }
        } else {
            applied = true;
        }
        if (selectionSet.contains(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName())) {
            response.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), applied);
        }
        return response;
    }

    private Object generateUuid(Column.ColumnType cqlType) {
        if (cqlType == Column.Type.Uuid) {
            return UUID.randomUUID();
        }
        if (cqlType == Column.Type.Timeuuid) {
            return Uuids.timeBased();
        }
        throw new AssertionError((Object)("This shouldn't get called for CQL type " + cqlType));
    }

    private void writeEntityField(String fieldName, Object value, DataFetchingFieldSelectionSet selectionSet, Map<String, Object> responseMap) {
        String selectionPattern;
        String rootPath = null;
        if (this.model.getResponsePayload().isPresent()) {
            ResponsePayloadModel responsePayload = this.model.getResponsePayload().get();
            if (!responsePayload.getEntityField().isPresent()) {
                return;
            }
            rootPath = responsePayload.getEntityField().get().getName();
        }
        String string = selectionPattern = rootPath == null ? fieldName : rootPath + '/' + fieldName;
        if (!selectionSet.contains(selectionPattern)) {
            return;
        }
        Map targetMap = rootPath == null ? responseMap : (Map)responseMap.computeIfAbsent(rootPath, __ -> new HashMap());
        targetMap.put(fieldName, value);
    }
}

