/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.FederatedEntity;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FederatedEntityFetcher
extends DeployedFetcher<List<FederatedEntity>> {
    private final MappingModel mappingModel;

    public FederatedEntityFetcher(MappingModel mappingModel) {
        super(mappingModel);
        this.mappingModel = mappingModel;
    }

    @Override
    protected List<FederatedEntity> get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        ArrayList<FederatedEntity> result = new ArrayList<FederatedEntity>();
        for (Map representation : (List)environment.getArgument("representations")) {
            result.add(this.getEntity(representation, dataStore, context));
        }
        return result;
    }

    private FederatedEntity getEntity(Map<String, Object> representation, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        Object rawTypeName = representation.get("__typename");
        if (!(rawTypeName instanceof String)) {
            throw new IllegalArgumentException("Entity representations must contain a '__typename' string field");
        }
        String entityName = (String)rawTypeName;
        EntityModel entityModel = this.mappingModel.getEntities().get(entityName);
        if (entityModel == null) {
            throw new IllegalArgumentException(String.format("Unknown entity type %s", entityName));
        }
        Keyspace keyspace = dataStore.schema().keyspace(entityModel.getKeyspaceName());
        List<BuiltCondition> whereConditions = this.bindWhere(entityModel.getPrimaryKeyWhereConditions(), entityModel, representation::containsKey, representation::get, keyspace);
        ResultSet resultSet = this.query(entityModel, whereConditions, Optional.empty(), Optional.empty(), Optional.empty(), dataStore, context);
        Map<String, Object> entity = this.toSingleEntity(resultSet, entityModel);
        return FederatedEntity.wrap(entityModel, entity);
    }
}

