/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundDelete;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.processor.DeleteModel;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class DeleteFetcher
extends DeployedFetcher<Object> {
    private final DeleteModel model;

    public DeleteFetcher(DeleteModel model, MappingModel mappingModel) {
        super(mappingModel);
        this.model = model;
    }

    @Override
    protected Object get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        Function<String, Object> getArgument;
        Predicate<String> hasArgument;
        EntityModel entityModel = this.model.getEntity();
        Keyspace keyspace = dataStore.schema().keyspace(entityModel.getKeyspaceName());
        if (this.model.getEntityArgumentName().isPresent()) {
            Map entity = (Map)environment.getArgument(this.model.getEntityArgumentName().get());
            hasArgument = entity::containsKey;
            getArgument = entity::get;
        } else {
            hasArgument = arg_0 -> ((DataFetchingEnvironment)environment).containsArgument(arg_0);
            getArgument = arg_0 -> ((DataFetchingEnvironment)environment).getArgument(arg_0);
        }
        List<BuiltCondition> whereConditions = this.bindWhere(this.model.getWhereConditions(), entityModel, hasArgument, getArgument, keyspace);
        List<BuiltCondition> ifConditions = this.bindIf(this.model.getIfConditions(), hasArgument, getArgument, keyspace);
        AbstractBound query = (AbstractBound)dataStore.queryBuilder().delete().from(entityModel.getKeyspaceName(), entityModel.getCqlName()).where(whereConditions).ifs(ifConditions).ifExists(this.model.ifExists()).build().bind(new Object[0]);
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), entityModel.getKeyspaceName(), entityModel.getCqlName(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDelete)query)), Scope.DELETE, SourceAPI.GRAPHQL);
        ResultSet resultSet = this.executeUnchecked(query, Optional.empty(), Optional.empty(), dataStore);
        boolean applied = !this.model.ifExists() || resultSet.one().getBoolean("[applied]");
        OperationModel.ReturnType returnType = this.model.getReturnType();
        if (returnType == OperationModel.SimpleReturnType.BOOLEAN) {
            return applied;
        }
        ResponsePayloadModel payload = (ResponsePayloadModel)returnType;
        if (payload.getTechnicalFields().contains((Object)ResponsePayloadModel.TechnicalField.APPLIED)) {
            return ImmutableMap.of((Object)ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), (Object)applied);
        }
        return Collections.emptyMap();
    }
}

