/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import com.google.common.annotations.VisibleForTesting;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.SchemaFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.List;
import java.util.function.Function;

public class AllSchemasFetcher
extends SchemaFetcher<List<SchemaSource>> {
    private final Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider;

    public AllSchemasFetcher() {
        this(SchemaSourceDao::new);
    }

    @VisibleForTesting
    public AllSchemasFetcher(Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider) {
        this.schemaSourceDaoProvider = schemaSourceDaoProvider;
    }

    @Override
    protected List<SchemaSource> get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws Exception {
        String keyspace = this.getKeyspace(environment, dataStore);
        this.authorize(context, keyspace);
        return this.schemaSourceDaoProvider.apply(dataStore).getAllVersions(keyspace);
    }
}

