/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableMap;
import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class MutationFetcher
extends DmlFetcher<CompletableFuture<Map<String, Object>>> {
    protected MutationFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
    }

    @Override
    protected CompletableFuture<Map<String, Object>> get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) {
        BoundQuery query = null;
        Exception buildException = null;
        try {
            query = this.buildQuery(environment, dataStore, context);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (this.containsDirective(operation, "atomic") && operation.getSelectionSet().getSelections().size() > 1) {
            return this.executeAsBatch(environment, dataStore, query, buildException, operation);
        }
        if (buildException != null) {
            CompletableFuture<Map<String, Object>> f = new CompletableFuture<Map<String, Object>>();
            f.completeExceptionally(buildException);
            return f;
        }
        if (this.containsDirective(operation, "async")) {
            return this.executeAsyncAccepted(dataStore, query, environment.getArgument("value"));
        }
        return dataStore.execute(query).thenApply(rs -> this.toMutationResult((ResultSet)rs, environment.getArgument("value")));
    }

    private CompletableFuture<Map<String, Object>> executeAsBatch(DataFetchingEnvironment environment, DataStore dataStore, BoundQuery query, Exception buildException, OperationDefinition operation) {
        boolean dataStoreAlreadySet;
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        StargateGraphqlContext context = (StargateGraphqlContext)environment.getContext();
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && (dataStoreAlreadySet = batchContext.setDataStore(dataStore))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(query) == selections) {
            DataStore batchDataStore = batchContext.getDataStore().orElse(dataStore);
            batchContext.setExecutionResult(batchDataStore.batch(batchContext.getQueries()));
        }
        if (this.containsDirective(operation, "async")) {
            return CompletableFuture.completedFuture(this.toAcceptedMutationResultWithOriginalValue(environment.getArgument("value")));
        }
        return batchContext.getExecutionFuture().thenApply(v -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
    }

    protected abstract BoundQuery buildQuery(DataFetchingEnvironment var1, DataStore var2, StargateGraphqlContext var3) throws Exception;
}

