/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.ImmutableParameters;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DbColumnGetter;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.FilterOperator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    private static final Logger log = LoggerFactory.getLogger(DmlFetcher.class);
    protected final Table table;
    protected final NameMapping nameMapping;
    protected final DbColumnGetter dbColumnGetter;

    protected DmlFetcher(Table table, NameMapping nameMapping) {
        this.table = table;
        this.nameMapping = nameMapping;
        this.dbColumnGetter = new DbColumnGetter(nameMapping);
    }

    @Override
    protected Parameters getDatastoreParameters(DataFetchingEnvironment environment) {
        Object pageState;
        Object pageSize;
        Object serialConsistency;
        Map options = (Map)environment.getArgument("options");
        if (options == null) {
            return DEFAULT_PARAMETERS;
        }
        ImmutableParameters.Builder builder = Parameters.builder().from(DEFAULT_PARAMETERS);
        Object consistency = options.get("consistency");
        if (consistency != null) {
            builder.consistencyLevel(ConsistencyLevel.valueOf((String)((String)consistency)));
        }
        if ((serialConsistency = options.get("serialConsistency")) != null) {
            builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)((String)serialConsistency)));
        }
        if ((pageSize = options.get("pageSize")) != null) {
            builder.pageSize(((Integer)pageSize).intValue());
        }
        if ((pageState = options.get("pageState")) != null) {
            builder.pagingState(ByteBuffer.wrap(Base64.getDecoder().decode((String)pageState)));
        }
        return builder.build();
    }

    protected List<BuiltCondition> buildConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<BuiltCondition> where = new ArrayList<BuiltCondition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(condition.getKey());
                where.add(operator.buildCondition(column, condition.getValue(), this.nameMapping));
            }
        }
        return where;
    }

    protected List<BuiltCondition> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, (String)entry.getKey());
            Object whereValue = this.toDBValue(column.type(), entry.getValue());
            relations.add(BuiltCondition.of((String)column.name(), (Predicate)Predicate.EQ, (Object)whereValue));
        }
        return relations;
    }

    protected List<Map<String, Object>> toListOfMutationResults(ResultSet resultSet, List<Map<String, Object>> originalValues) {
        List rows = resultSet.currentPageRows();
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (rows.isEmpty()) {
            for (Map<String, Object> originalValue : originalValues) {
                results.add((Map<String, Object>)this.toAppliedMutationResultWithOriginalValue(originalValue));
            }
        } else {
            for (int i = 0; i <= rows.size(); ++i) {
                Row row = (Row)rows.get(i);
                Map<String, Object> originalValue = originalValues.get(i);
                results.add((Map<String, Object>)this.toMutationResultSingleRow(originalValue, row));
            }
        }
        return results;
    }

    protected CompletableFuture<List<Map<String, Object>>> toListOfMutationResultsAccepted(List<Map<String, Object>> originalValues) {
        ArrayList<ImmutableMap<String, Object>> results = new ArrayList<ImmutableMap<String, Object>>();
        for (Map<String, Object> originalValue : originalValues) {
            results.add(this.toAcceptedMutationResultWithOriginalValue(originalValue));
        }
        return CompletableFuture.completedFuture(results);
    }

    protected Map<String, Object> toMutationResult(ResultSet resultSet, Object originalValue) {
        List rows = resultSet.currentPageRows();
        if (rows.isEmpty()) {
            return this.toAppliedMutationResultWithOriginalValue(originalValue);
        }
        Row row = (Row)rows.iterator().next();
        return this.toMutationResultSingleRow(originalValue, row);
    }

    private ImmutableMap<String, Object> toAppliedMutationResultWithOriginalValue(Object originalValue) {
        return ImmutableMap.of((Object)"value", (Object)originalValue, (Object)"applied", (Object)true);
    }

    protected ImmutableMap<String, Object> toAcceptedMutationResultWithOriginalValue(Object originalValue) {
        return ImmutableMap.of((Object)"value", (Object)originalValue, (Object)"accepted", (Object)true);
    }

    private ImmutableMap<String, Object> toMutationResultSingleRow(Object originalValue, Row row) {
        boolean applied = row.getBoolean("[applied]");
        Map<String, Object> value = DataTypeMapping.toGraphQLValue(this.nameMapping, this.table, row);
        Map<String, Object> finalValue = applied ? originalValue : value;
        return ImmutableMap.of((Object)"value", finalValue, (Object)"applied", (Object)applied);
    }

    protected boolean containsDirective(OperationDefinition operation, String directive) {
        return operation.getDirectives().stream().anyMatch(d -> d.getName().equals(directive));
    }

    protected CompletableFuture<Map<String, Object>> executeAsyncAccepted(DataStore dataStore, BoundQuery query, Object originalValue) {
        dataStore.execute(query).whenComplete((r, throwable) -> {
            if (throwable != null) {
                log.warn(String.format("The query %s executed within the %s directive failed.", query, "async"), throwable);
            }
        });
        return CompletableFuture.completedFuture(this.toAcceptedMutationResultWithOriginalValue(originalValue));
    }

    protected String getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return column.name();
    }

    protected Column getColumn(Table table, String fieldName) {
        String columnName = this.nameMapping.getCqlName(table, fieldName);
        return table.column(columnName);
    }

    protected Object toDBValue(Column column, Object value) {
        return this.toDBValue(column.type(), value);
    }

    private Object toDBValue(Column.ColumnType type, Object value) {
        return DataTypeMapping.toDBValue(type, value, this.nameMapping);
    }
}

