/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.BulkMutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.TtlFromOptionsExtractor;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BulkInsertMutationFetcher
extends BulkMutationFetcher {
    public BulkInsertMutationFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
    }

    @Override
    protected List<BoundQuery> buildQueries(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws UnauthorizedException {
        boolean ifNotExists = environment.containsArgument("ifNotExists") && environment.getArgument("ifNotExists") != null && (Boolean)environment.getArgument("ifNotExists") != false;
        List valuesToInsert = (List)environment.getArgument("values");
        ArrayList<BoundQuery> boundQueries = new ArrayList<BoundQuery>(valuesToInsert.size());
        for (Map value : valuesToInsert) {
            BoundQuery query = dataStore.queryBuilder().insertInto(this.table.keyspace(), this.table.name()).value(this.buildInsertValues(value)).ifNotExists(ifNotExists).ttl(TtlFromOptionsExtractor.getTTL(environment)).build().bind(new Object[0]);
            context.getAuthorizationService().authorizeDataWrite(context.getSubject(), this.table.keyspace(), this.table.name(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY, SourceAPI.GRAPHQL);
            boundQueries.add(query);
        }
        return boundQueries;
    }

    private List<ValueModifier> buildInsertValues(Map<String, Object> value) {
        ArrayList<ValueModifier> modifiers = new ArrayList<ValueModifier>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(this.table, entry.getKey());
            modifiers.add(ValueModifier.set((String)column.name(), (Object)this.toDBValue(column, entry.getValue())));
        }
        return modifiers;
    }
}

