/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.KeyspaceDto;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.Collections;

public class SingleKeyspaceFetcher
extends CassandraFetcher<KeyspaceDto> {
    @Override
    protected KeyspaceDto get(DataFetchingEnvironment environment, DataStore dataStore, StargateGraphqlContext context) throws Exception {
        String keyspaceName = (String)environment.getArgument("name");
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            return null;
        }
        context.getAuthorizationService().authorizeSchemaRead(context.getSubject(), Collections.singletonList(keyspace.name()), null, SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
        return new KeyspaceDto(keyspace, context.getAuthorizationService(), context.getSubject());
    }
}

