/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.graphql.web.StargateGraphqlContext;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class CassandraFetcher<ResultT>
implements DataFetcher<ResultT> {
    public static final ConsistencyLevel DEFAULT_CONSISTENCY = ConsistencyLevel.LOCAL_QUORUM;
    public static final ConsistencyLevel DEFAULT_SERIAL_CONSISTENCY = ConsistencyLevel.SERIAL;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final Parameters DEFAULT_PARAMETERS = Parameters.builder().pageSize(100).consistencyLevel(DEFAULT_CONSISTENCY).serialConsistencyLevel(DEFAULT_SERIAL_CONSISTENCY).build();

    public final ResultT get(DataFetchingEnvironment environment) throws Exception {
        StargateGraphqlContext context = (StargateGraphqlContext)environment.getContext();
        AuthenticationSubject authenticationSubject = context.getSubject();
        Parameters parameters = this.getDatastoreParameters(environment);
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().putAllCustomProperties(context.getAllHeaders()).defaultParameters(parameters).alwaysPrepareQueries(true).build();
        DataStore dataStore = context.getDataStoreFactory().create(authenticationSubject.asUser(), (DataStoreOptions)dataStoreOptions);
        return this.get(environment, dataStore, context);
    }

    protected Parameters getDatastoreParameters(DataFetchingEnvironment environment) {
        return DEFAULT_PARAMETERS;
    }

    protected abstract ResultT get(DataFetchingEnvironment var1, DataStore var2, StargateGraphqlContext var3) throws Exception;
}

