/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import graphql.GraphQL;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.Authenticated;
import io.stargate.graphql.web.resources.GraphqlCache;
import io.stargate.graphql.web.resources.GraphqlResourceBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Singleton
@Path(value="/graphql-admin")
@Produces(value={"application/json"})
@Authenticated
public class AdminResource
extends GraphqlResourceBase {
    private final GraphQL graphql;

    @Inject
    public AdminResource(GraphqlCache graphqlCache) {
        this.graphql = graphqlCache.getSchemaFirstAdminGraphql();
    }

    @GET
    public void get(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        AdminResource.get(query, operationName, variables, this.graphql, httpRequest, asyncResponse);
    }

    @POST
    @Consumes(value={"application/json"})
    public void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        AdminResource.postJson(jsonBody, queryFromUrl, this.graphql, httpRequest, asyncResponse);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public void postMultipartJson(@FormDataParam(value="operations") GraphqlJsonBody graphqlPart, FormDataMultiPart allParts, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        AdminResource.postMultipartJson(graphqlPart, allParts, this.graphql, httpRequest, asyncResponse);
    }

    @POST
    @Consumes(value={"application/graphql"})
    public void postGraphql(String query, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        AdminResource.postGraphql(query, this.graphql, httpRequest, asyncResponse);
    }
}

