/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.Type;
import io.stargate.db.query.Predicate;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.WhereConditionModel;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.Map;
import java.util.Optional;

class WhereConditionModelBuilder
extends ModelBuilderBase<WhereConditionModel> {
    private final InputValueDefinition argument;
    private final String operationName;
    private final EntityModel entity;
    private final Map<String, EntityModel> entities;

    WhereConditionModelBuilder(InputValueDefinition argument, String operationName, EntityModel entity, Map<String, EntityModel> entities, ProcessingContext context) {
        super(context, argument.getSourceLocation());
        this.argument = argument;
        this.operationName = operationName;
        this.entity = entity;
        this.entities = entities;
    }

    @Override
    WhereConditionModel build() throws SkipException {
        Optional<Directive> whereDirective = DirectiveHelper.getDirective("cql_where", this.argument);
        String fieldName = whereDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "field", this.context)).orElse(this.argument.getName());
        Predicate predicate = whereDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "predicate", Predicate.class, this.context)).orElse(Predicate.EQ);
        if (predicate == Predicate.NEQ) {
            this.invalidMapping("Operation %s: predicate NEQ (on %s) is not allowed for WHERE conditions", this.operationName, this.argument.getName());
            throw SkipException.INSTANCE;
        }
        FieldModel field = this.findField(fieldName);
        if (field.isPartitionKey()) {
            this.checkValidForPartitionKey(predicate, field);
        } else if (field.isClusteringColumn()) {
            this.checkValidForClusteringColumn(predicate, field);
        } else {
            this.checkValidForRegularColumn(predicate, field);
        }
        return new WhereConditionModel(field, predicate, this.argument.getName());
    }

    private FieldModel findField(String fieldName) throws SkipException {
        return this.entity.getAllColumns().stream().filter(f -> f.getGraphqlName().equals(fieldName)).findFirst().orElseThrow(() -> {
            this.invalidMapping("Operation %s: could not find field %s in type %s", this.operationName, fieldName, this.entity.getGraphqlName());
            return SkipException.INSTANCE;
        });
    }

    private void checkValidForPartitionKey(Predicate predicate, FieldModel field) throws SkipException {
        switch (predicate) {
            case EQ: {
                this.checkArgumentIsSameAs(field);
                break;
            }
            case IN: {
                this.checkArgumentIsListOf(field);
                break;
            }
            default: {
                this.invalidMapping("Operation %s: predicate %s is not supported for partition key field %s (expected EQ or IN)", this.operationName, predicate, field.getGraphqlName());
                throw SkipException.INSTANCE;
            }
        }
    }

    private void checkValidForClusteringColumn(Predicate predicate, FieldModel field) throws SkipException {
        switch (predicate) {
            case EQ: 
            case LT: 
            case GT: 
            case LTE: 
            case GTE: {
                this.checkArgumentIsSameAs(field);
                break;
            }
            case IN: {
                this.checkArgumentIsListOf(field);
                break;
            }
            default: {
                this.invalidMapping("Operation %s: predicate %s is not supported for clustering field %s (expected EQ, LT, GT, LTE, GTE or IN)", this.operationName, predicate, field.getGraphqlName());
                throw SkipException.INSTANCE;
            }
        }
    }

    private void checkValidForRegularColumn(Predicate predicate, FieldModel field) throws SkipException {
        IndexModel index = field.getIndex().orElseThrow(() -> {
            this.invalidMapping("Operation %s: non-primary key argument %s must be indexed in order to use it in a condition", this.operationName, this.argument.getName());
            return SkipException.INSTANCE;
        });
        if (!index.isCustom()) {
            switch (predicate) {
                case EQ: {
                    this.checkArgumentIsSameAs(field);
                    break;
                }
                case IN: {
                    this.checkArgumentIsListOf(field);
                    break;
                }
                case CONTAINS: {
                    this.checkArgumentIsElementOf(field);
                    break;
                }
                default: {
                    this.invalidMapping("Operation %s: predicate %s is not supported for indexed field %s (expected EQ, IN or CONTAINS)", this.operationName, predicate, field.getGraphqlName());
                    throw SkipException.INSTANCE;
                }
            }
        }
    }

    private void checkArgumentIsSameAs(FieldModel field) throws SkipException {
        Type<?> fieldInputType;
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        if (!argumentType.isEqualTo(fieldInputType = this.toInput(field.getGraphqlType(), this.argument, this.entity, field))) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match %s.%s", this.operationName, this.argument.getName(), TypeHelper.format(fieldInputType), this.entity.getGraphqlName(), field.getGraphqlName());
            throw SkipException.INSTANCE;
        }
    }

    private void checkArgumentIsListOf(FieldModel field) throws SkipException {
        Type<?> fieldInputType;
        ListType expectedArgumentType;
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        if (!argumentType.isEqualTo((Node)(expectedArgumentType = ListType.newListType(fieldInputType = this.toInput(field.getGraphqlType(), this.argument, this.entity, field)).build()))) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match %s.%s", this.operationName, this.argument.getName(), TypeHelper.format(expectedArgumentType), this.entity.getGraphqlName(), field.getGraphqlName());
        }
    }

    private void checkArgumentIsElementOf(FieldModel field) throws SkipException {
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        Type<?> fieldInputType = this.toInput(field.getGraphqlType(), this.argument, this.entity, field);
        if (!(fieldInputType instanceof ListType)) {
            this.invalidMapping("Operation %s: CONTAINS predicate cannot be used with argument %s because it is not a list", this.operationName, this.argument.getName());
            throw SkipException.INSTANCE;
        }
        Type expectedArgumentType = ((ListType)fieldInputType).getType();
        if (!argumentType.isEqualTo((Node)expectedArgumentType)) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match element type of %s.%s", this.operationName, this.argument.getName(), TypeHelper.format(expectedArgumentType), this.entity.getGraphqlName(), field.getGraphqlName());
        }
    }

    private Type<?> toInput(Type<?> fieldType, InputValueDefinition inputValue, EntityModel entity, FieldModel field) throws SkipException {
        try {
            return TypeHelper.toInput(TypeHelper.unwrapNonNull(fieldType), this.entities);
        }
        catch (IllegalArgumentException e) {
            this.invalidMapping("Operation %s: can't infer expected input type for %s (matching %s.%s) because %s", this.operationName, inputValue.getName(), entity.getGraphqlName(), field.getGraphqlName(), e.getMessage());
            throw SkipException.INSTANCE;
        }
    }
}

