/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.InsertModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class InsertModelBuilder
extends MutationModelBuilder {
    private final String parentTypeName;

    InsertModelBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(mutation, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    InsertModel build() throws SkipException {
        boolean ifNotExists = this.computeIfNotExists();
        List inputs = this.operation.getInputValueDefinitions();
        if (inputs.isEmpty()) {
            this.invalidMapping("Mutation %s: inserts must take the entity input type as the first argument", this.operationName);
            throw SkipException.INSTANCE;
        }
        if (inputs.size() > 1) {
            this.invalidMapping("Mutation %s: inserts can't have more than one argument", this.operationName);
            throw SkipException.INSTANCE;
        }
        InputValueDefinition input = (InputValueDefinition)inputs.get(0);
        EntityModel entity = this.findEntity(input).orElseThrow(() -> {
            this.invalidMapping("Mutation %s: unexpected argument type, inserts expect an input object that maps to a CQL entity", this.operationName);
            return SkipException.INSTANCE;
        });
        OperationModel.ReturnType returnType = this.getReturnType("Mutation " + this.operationName);
        if (returnType.isEntityList() || !returnType.getEntity().filter(e -> e.equals(entity)).isPresent()) {
            this.invalidMapping("Mutation %s: invalid return type. Expected %s, or a response payload that wraps a single instance of it.", this.operationName, entity.getGraphqlName());
        }
        Optional<ResponsePayloadModel> responsePayload = Optional.of(returnType).filter(ResponsePayloadModel.class::isInstance).map(ResponsePayloadModel.class::cast);
        return new InsertModel(this.parentTypeName, this.operation, entity, input.getName(), responsePayload, ifNotExists);
    }

    private boolean computeIfNotExists() {
        Optional fromDirective = DirectiveHelper.getDirective("cql_insert", this.operation).flatMap(d -> DirectiveHelper.getBooleanArgument(d, "ifNotExists", this.context));
        if (fromDirective.isPresent()) {
            return (Boolean)fromDirective.get();
        }
        if (this.operation.getName().endsWith("IfNotExists")) {
            this.info("Mutation %s: setting the 'ifNotExists' flag implicitly because the name follows the naming convention.", this.operationName);
            return true;
        }
        return false;
    }
}

