/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class CreateIndexQuery
extends MigrationQuery {
    private final Table table;
    private final SecondaryIndex index;

    public CreateIndexQuery(Table table, SecondaryIndex index) {
        this.table = table;
        this.index = index;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().create().index(this.index.name()).on(this.table).column(this.index.column()).indexingType(this.index.indexingType()).custom(this.index.indexingClass()).options(this.index.indexingOptions()).build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return String.format("Create index %s on %s.%s", this.index.name(), this.table.name(), this.index.column().name());
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return false;
    }

    @Override
    protected boolean addsReferenceTo(String udtName) {
        return false;
    }

    @Override
    protected boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

