/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.google.common.base.Throwables;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.cqlfirst.SchemaFactory;
import io.stargate.graphql.schema.graphqlfirst.AdminSchemaBuilder;
import io.stargate.graphql.schema.graphqlfirst.migration.CassandraMigrator;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.graphql.schema.graphqlfirst.processor.SchemaProcessor;
import io.stargate.graphql.web.resources.KeyspaceChangeListener;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlCache
implements KeyspaceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlCache.class);
    private static final boolean DISABLE_DEFAULT_KEYSPACE = Boolean.getBoolean("stargate.graphql.default_keyspace.disabled");
    private final Persistence persistence;
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    private final boolean enableGraphqlFirst;
    private final GraphQL ddlGraphql;
    private final GraphQL schemaFirstAdminGraphql;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, DmlGraphqlHolder> dmlGraphqls = new ConcurrentHashMap<String, DmlGraphqlHolder>();

    public GraphqlCache(Persistence persistence, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory, boolean enableGraphqlFirst) {
        this.persistence = persistence;
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
        this.enableGraphqlFirst = enableGraphqlFirst;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema(authorizationService, dataStoreFactory));
        this.schemaFirstAdminGraphql = GraphQL.newGraphQL((GraphQLSchema)new AdminSchemaBuilder(authorizationService, dataStoreFactory).build()).build();
        this.defaultKeyspace = GraphqlCache.findDefaultKeyspace(dataStoreFactory.createInternal());
        persistence.registerEventListener((EventListener)this);
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getSchemaFirstAdminGraphql() {
        return this.schemaFirstAdminGraphql;
    }

    public GraphQL getDml(String keyspaceName, AuthenticationSubject subject, Map<String, String> headers) throws Exception {
        boolean installed;
        DataStore dataStore = this.buildUserDatastore(subject, headers);
        SchemaSource latestSource = this.enableGraphqlFirst ? new SchemaSourceDao(dataStore).getLatestVersion(keyspaceName) : null;
        String decoratedKeyspaceName = this.persistence.decorateKeyspaceName(keyspaceName, headers);
        DmlGraphqlHolder currentHolder = (DmlGraphqlHolder)this.dmlGraphqls.get(decoratedKeyspaceName);
        if (currentHolder != null && currentHolder.isSameVersionAs(latestSource)) {
            LOG.trace("Returning cached schema for {}", (Object)decoratedKeyspaceName);
            return currentHolder.getGraphql();
        }
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            LOG.trace("Keyspace {} does not exist", (Object)decoratedKeyspaceName);
            return null;
        }
        LOG.trace("Computing new version for {} ({})", (Object)decoratedKeyspaceName, (Object)(currentHolder == null ? "wasn't cached before" : "schema has changed"));
        DmlGraphqlHolder newHolder = new DmlGraphqlHolder(latestSource, keyspace);
        boolean bl = currentHolder == null ? this.dmlGraphqls.putIfAbsent(decoratedKeyspaceName, newHolder) == null : (installed = this.dmlGraphqls.replace(decoratedKeyspaceName, currentHolder, newHolder));
        if (installed) {
            LOG.trace("Installing new version for {} in the cache", (Object)decoratedKeyspaceName);
            newHolder.init();
            return newHolder.getGraphql();
        }
        LOG.trace("Got beat installing new version for {} in the cache, fetching again", (Object)decoratedKeyspaceName);
        currentHolder = (DmlGraphqlHolder)this.dmlGraphqls.get(decoratedKeyspaceName);
        return currentHolder == null ? null : currentHolder.getGraphql();
    }

    public String getDefaultKeyspaceName() {
        return this.defaultKeyspace;
    }

    private DataStore buildUserDatastore(AuthenticationSubject subject, Map<String, String> headers) {
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().putAllCustomProperties(headers).build();
        return this.dataStoreFactory.create(subject.asUser(), (DataStoreOptions)dataStoreOptions);
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL((GraphQLSchema)schema).mutationExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        if (DISABLE_DEFAULT_KEYSPACE) {
            return null;
        }
        try {
            CompletableFuture query = dataStore.queryBuilder().select().column("keyspace_name").writeTimeColumn("durable_writes", "wt").from("system_schema", "keyspaces").build().execute(ConsistencyLevel.LOCAL_QUORUM, new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Optional<Row> first = resultSet.rows().stream().filter(r -> !r.isNull("wt")).filter(r -> r.getLong("wt") > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong("wt")));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    @Override
    @FormatMethod
    public void onKeyspaceChanged(String decoratedKeyspaceName, @FormatString String reason, Object ... reasonArguments) {
        DmlGraphqlHolder holder = (DmlGraphqlHolder)this.dmlGraphqls.get(decoratedKeyspaceName);
        if (holder != null && holder.isCqlFirst() && this.dmlGraphqls.remove(decoratedKeyspaceName) != null && LOG.isDebugEnabled()) {
            LOG.debug("Invalidated GraphQL schema for keyspace {} because {}", (Object)decoratedKeyspaceName, (Object)String.format(reason, reasonArguments));
        }
    }

    class DmlGraphqlHolder {
        private final SchemaSource source;
        private final Keyspace keyspace;
        private final CompletableFuture<GraphQL> graphqlFuture = new CompletableFuture();

        DmlGraphqlHolder(SchemaSource source, Keyspace keyspace) {
            this.source = source;
            this.keyspace = keyspace;
        }

        void init() {
            try {
                this.graphqlFuture.complete(this.buildGraphql());
            }
            catch (Exception e) {
                this.graphqlFuture.completeExceptionally(e);
            }
        }

        private GraphQL buildGraphql() {
            if (this.source == null) {
                return GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(GraphqlCache.this.authorizationService, this.keyspace, GraphqlCache.this.dataStoreFactory));
            }
            ProcessedSchema processedSchema = new SchemaProcessor(GraphqlCache.this.authorizationService, GraphqlCache.this.dataStoreFactory, true).process(this.source.getContents(), this.keyspace);
            CassandraMigrator.forPersisted().compute(processedSchema.getMappingModel(), this.keyspace);
            return processedSchema.getGraphql();
        }

        boolean isSameVersionAs(SchemaSource otherSource) {
            return this.source == null && otherSource == null || this.source != null && otherSource != null && this.source.getVersion().equals(otherSource.getVersion());
        }

        boolean isCqlFirst() {
            return this.source == null;
        }

        GraphQL getGraphql() throws Exception {
            try {
                return this.graphqlFuture.get();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

