/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.UpdateModel;
import java.util.List;
import java.util.Map;

class UpdateModelBuilder
extends MutationModelBuilder {
    private final String parentTypeName;

    UpdateModelBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(mutation, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    MutationModel build() throws SkipException {
        OperationModel.ReturnType returnType = this.getReturnType("Mutation " + this.operationName);
        if (returnType != OperationModel.SimpleReturnType.BOOLEAN) {
            this.invalidMapping("Mutation %s: updates can only return Boolean", this.operationName);
            throw SkipException.INSTANCE;
        }
        List inputs = this.operation.getInputValueDefinitions();
        if (inputs.isEmpty()) {
            this.invalidMapping("Mutation %s: updates must take the entity input type as the first argument", this.operationName);
            throw SkipException.INSTANCE;
        }
        if (inputs.size() > 1) {
            this.invalidMapping("Mutation %s: updates can't have more than one argument", this.operationName);
            throw SkipException.INSTANCE;
        }
        InputValueDefinition input = (InputValueDefinition)inputs.get(0);
        EntityModel entity = this.findEntity(input).orElseThrow(() -> {
            this.invalidMapping("Mutation %s: unexpected argument type, updates expect an input object that maps to a CQL entity", this.operationName);
            return SkipException.INSTANCE;
        });
        return new UpdateModel(this.parentTypeName, this.operation, entity, input.getName());
    }
}

