/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableList;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.WhereConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.WhereConditionModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;

abstract class OperationModelBuilderBase<T extends OperationModel>
extends ModelBuilderBase<T> {
    protected final FieldDefinition operation;
    protected final String operationName;
    protected final Map<String, EntityModel> entities;
    protected final Map<String, ResponsePayloadModel> responsePayloads;

    protected OperationModelBuilderBase(FieldDefinition operation, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(context, operation.getSourceLocation());
        this.operation = operation;
        this.operationName = operation.getName();
        this.entities = entities;
        this.responsePayloads = responsePayloads;
    }

    OperationModel.ReturnType getReturnType(String operationDescription) throws SkipException {
        Type<?> graphqlType = TypeHelper.unwrapNonNull(this.operation.getType());
        if (graphqlType instanceof ListType) {
            EntityModel entity;
            Type<?> elementType = ((ListType)graphqlType).getType();
            if ((elementType = TypeHelper.unwrapNonNull(elementType)) instanceof TypeName && (entity = this.entities.get(((TypeName)elementType).getName())) != null) {
                return new OperationModel.EntityListReturnType(entity);
            }
        } else {
            assert (graphqlType instanceof TypeName);
            String typeName = ((TypeName)graphqlType).getName();
            OperationModel.SimpleReturnType simple = OperationModel.SimpleReturnType.fromTypeName(typeName);
            if (simple != null) {
                return simple;
            }
            EntityModel entity = this.entities.get(typeName);
            if (entity != null) {
                return new OperationModel.EntityReturnType(entity);
            }
            ResponsePayloadModel payload = this.responsePayloads.get(typeName);
            if (payload != null) {
                return payload;
            }
        }
        this.invalidMapping("%s: unsupported return type %s", operationDescription, TypeHelper.format(graphqlType));
        throw SkipException.INSTANCE;
    }

    protected List<WhereConditionModel> buildWhereConditions(EntityModel entity) throws SkipException {
        ImmutableList.Builder whereConditionsBuilder = ImmutableList.builder();
        boolean foundErrors = false;
        for (InputValueDefinition inputValue : this.operation.getInputValueDefinitions()) {
            if (DirectiveHelper.getDirective("cql_pagingState", inputValue).isPresent()) continue;
            try {
                whereConditionsBuilder.add((Object)new WhereConditionModelBuilder(inputValue, this.operationName, entity, this.entities, this.context).build());
            }
            catch (SkipException __) {
                foundErrors = true;
            }
        }
        if (foundErrors) {
            throw SkipException.INSTANCE;
        }
        return whereConditionsBuilder.build();
    }

    protected void validateNoFiltering(List<WhereConditionModel> whereConditions, EntityModel entity) throws SkipException {
        Optional<String> maybeError = entity.validateNoFiltering(whereConditions);
        if (maybeError.isPresent()) {
            this.invalidMapping("Operation %s: %s", this.operationName, maybeError.get());
            throw SkipException.INSTANCE;
        }
    }
}

