/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableMap;
import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.ParameterizedType;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class FieldModelBuilder
extends ModelBuilderBase<FieldModel> {
    private static final Map<String, Column.ColumnType> GRAPHQL_SCALAR_MAPPINGS = ImmutableMap.builder().put((Object)Scalars.GraphQLInt.getName(), (Object)Column.Type.Int).put((Object)Scalars.GraphQLFloat.getName(), (Object)Column.Type.Double).put((Object)Scalars.GraphQLString.getName(), (Object)Column.Type.Varchar).put((Object)Scalars.GraphQLBoolean.getName(), (Object)Column.Type.Boolean).put((Object)Scalars.GraphQLID.getName(), (Object)Column.Type.Uuid).build();
    private final FieldDefinition field;
    private final String parentCqlName;
    private final EntityModel.Target targetContainer;
    private final boolean checkForInputType;
    private final String graphqlName;
    private final Type<?> graphqlType;
    private final String messagePrefix;
    private final Optional<Directive> cqlColumnDirective;

    FieldModelBuilder(FieldDefinition field, ProcessingContext context, String parentCqlName, String parentGraphqlName, EntityModel.Target targetContainer, boolean checkForInputType) {
        super(context, field.getSourceLocation());
        this.field = field;
        this.parentCqlName = parentCqlName;
        this.targetContainer = targetContainer;
        this.checkForInputType = checkForInputType;
        this.graphqlName = field.getName();
        this.graphqlType = field.getType();
        this.messagePrefix = parentGraphqlName + "." + this.graphqlName;
        this.cqlColumnDirective = DirectiveHelper.getDirective("cql_column", field);
    }

    @Override
    FieldModel build() throws SkipException {
        String cqlName = this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "name", this.context)).orElse(this.graphqlName);
        boolean isUdtField = this.targetContainer == EntityModel.Target.UDT;
        boolean partitionKey = this.isPartitionKey(isUdtField);
        Optional<Column.Order> clusteringOrder = this.getClusteringOrder(isUdtField);
        if (partitionKey && clusteringOrder.isPresent()) {
            this.invalidMapping("%s: can't be both a partition key and a clustering key.", this.messagePrefix);
            throw SkipException.INSTANCE;
        }
        boolean isPk = partitionKey || clusteringOrder.isPresent();
        Column.ColumnType cqlType = this.inferCqlType(this.graphqlType, this.context);
        if (isPk || cqlType.isUserDefined() && isUdtField) {
            cqlType = cqlType.frozen();
        }
        cqlType = this.maybeUseTypeHint(cqlType, isPk, isUdtField);
        return new FieldModel(this.graphqlName, this.graphqlType, cqlName, cqlType, partitionKey, clusteringOrder, this.getIndex(cqlName, isUdtField, isPk, cqlType));
    }

    private Boolean isPartitionKey(boolean isUdtField) {
        return this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "partitionKey", this.context)).filter(__ -> {
            if (isUdtField) {
                this.warn("%s: UDT fields should not be marked as partition keys (this will be ignored)", this.messagePrefix);
                return false;
            }
            return true;
        }).orElse(false);
    }

    private Optional<Column.Order> getClusteringOrder(boolean isUdtField) {
        return this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "clusteringOrder", Column.Order.class, this.context)).filter(__ -> {
            if (isUdtField) {
                this.warn("%s: UDT fields should not be marked as clustering keys (this will be ignored)", this.messagePrefix);
                return false;
            }
            return true;
        });
    }

    private Column.ColumnType inferCqlType(Type<?> graphqlType, ProcessingContext context) throws SkipException {
        if (graphqlType instanceof NonNullType) {
            return this.inferCqlType(((NonNullType)graphqlType).getType(), context);
        }
        if (graphqlType instanceof ListType) {
            return Column.Type.List.of(new Column.ColumnType[]{this.inferCqlType(((ListType)graphqlType).getType(), context)});
        }
        String typeName = ((TypeName)graphqlType).getName();
        TypeDefinitionRegistry typeRegistry = context.getTypeRegistry();
        if (GRAPHQL_SCALAR_MAPPINGS.containsKey(typeName)) {
            return GRAPHQL_SCALAR_MAPPINGS.get(typeName);
        }
        if (typeRegistry.types().containsKey(typeName)) {
            TypeDefinition definition = (TypeDefinition)typeRegistry.getType(typeName).orElseThrow(AssertionError::new);
            if (definition instanceof EnumTypeDefinition) {
                return Column.Type.Varchar;
            }
            if (definition instanceof ObjectTypeDefinition) {
                return this.expectUdt((ObjectTypeDefinition)definition);
            }
            this.invalidMapping("%s: can't map type '%s' to CQL", this.messagePrefix, graphqlType);
            throw SkipException.INSTANCE;
        }
        Optional<CqlScalar> maybeCqlScalar = CqlScalar.fromGraphqlName(typeName);
        if (maybeCqlScalar.isPresent()) {
            CqlScalar cqlScalar = maybeCqlScalar.get();
            context.getUsedCqlScalars().add(cqlScalar);
            if (!typeRegistry.scalars().containsKey(typeName)) {
                typeRegistry.add((SDLDefinition)ScalarTypeDefinition.newScalarTypeDefinition().name(cqlScalar.getGraphqlType().getName()).build());
            }
            return cqlScalar.getCqlType();
        }
        this.invalidMapping("%s: can't map type '%s' to CQL", this.messagePrefix, graphqlType);
        throw SkipException.INSTANCE;
    }

    private Column.ColumnType expectUdt(ObjectTypeDefinition definition) throws SkipException {
        boolean isUdt = DirectiveHelper.getDirective("cql_entity", definition).flatMap(d -> DirectiveHelper.getEnumArgument(d, "target", EntityModel.Target.class, this.context)).filter(target -> target == EntityModel.Target.UDT).isPresent();
        if (isUdt) {
            if (this.checkForInputType && !DirectiveHelper.getDirective("cql_input", definition).isPresent()) {
                this.invalidMapping("%s: type '%s' must also be annotated with @cql_input", this.messagePrefix, definition.getName());
                throw SkipException.INSTANCE;
            }
            return ImmutableUserDefinedType.builder().keyspace(this.context.getKeyspace().name()).name(definition.getName()).build();
        }
        this.invalidMapping("%s: can't map type '%s' to CQL -- if a field references an object type, then that object should map to a UDT", this.messagePrefix, definition.getName());
        throw SkipException.INSTANCE;
    }

    private Column.ColumnType maybeUseTypeHint(Column.ColumnType cqlType, boolean isPk, boolean isUdtField) throws SkipException {
        Column.ColumnType cqlTypeHint;
        Optional maybeCqlTypeHint = this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "typeHint", this.context));
        if (!maybeCqlTypeHint.isPresent()) {
            return cqlType;
        }
        String spec = (String)maybeCqlTypeHint.get();
        try {
            cqlTypeHint = Column.Type.fromCqlDefinitionOf((Keyspace)this.context.getKeyspace(), (String)spec, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            this.invalidSyntax("%s: could not parse CQL type '%s': %s", this.messagePrefix, spec, e.getMessage());
            throw SkipException.INSTANCE;
        }
        if (isPk && (cqlTypeHint.isParameterized() || cqlTypeHint.isUserDefined()) && !cqlTypeHint.isFrozen()) {
            this.invalidMapping("%s: invalid type hint '%s' -- partition or clustering columns must be frozen", this.messagePrefix, spec);
            throw SkipException.INSTANCE;
        }
        if (cqlTypeHint.isUserDefined() && isUdtField && !cqlTypeHint.isFrozen()) {
            this.invalidMapping("%s: invalid type hint '%s' -- nested UDTs must be frozen", this.messagePrefix, spec);
            throw SkipException.INSTANCE;
        }
        if (!FieldModelBuilder.isCompatible(cqlTypeHint, cqlType)) {
            this.invalidMapping("%s: invalid type hint '%s'-- the inferred type was '%s', you can only change frozenness or use sets instead of lists", this.messagePrefix, cqlTypeHint.cqlDefinition(), cqlType.cqlDefinition());
            throw SkipException.INSTANCE;
        }
        return cqlTypeHint;
    }

    private static boolean isCompatible(Column.ColumnType type1, Column.ColumnType type2) {
        Column.Type raw2;
        Column.Type raw1 = FieldModelBuilder.turnSetIntoList(type1.rawType());
        if (!Objects.equals(raw1, raw2 = FieldModelBuilder.turnSetIntoList(type2.rawType()))) {
            return false;
        }
        if (raw2 == Column.Type.UDT) {
            UserDefinedType udt1 = (UserDefinedType)type1;
            UserDefinedType udt2 = (UserDefinedType)type2;
            return Objects.equals(udt1.keyspace(), udt2.keyspace()) && Objects.equals(udt1.name(), udt2.name());
        }
        if (raw2.isParameterized()) {
            ParameterizedType parameterized1 = (ParameterizedType)type1;
            ParameterizedType parameterized2 = (ParameterizedType)type2;
            if (parameterized1.parameters().size() != parameterized2.parameters().size()) {
                return false;
            }
            for (int i = 0; i < parameterized1.parameters().size(); ++i) {
                Column.ColumnType sub2;
                Column.ColumnType sub1 = (Column.ColumnType)parameterized1.parameters().get(i);
                if (FieldModelBuilder.isCompatible(sub1, sub2 = (Column.ColumnType)parameterized2.parameters().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static Column.Type turnSetIntoList(Column.Type type) {
        return type == Column.Type.Set ? Column.Type.List : type;
    }

    private Optional<IndexModel> getIndex(String cqlName, boolean isUdtField, boolean isPk, Column.ColumnType cqlType) throws SkipException {
        Optional<Directive> cqlIndexDirective = DirectiveHelper.getDirective("cql_index", this.field);
        if (cqlIndexDirective.isPresent()) {
            if (isPk) {
                this.invalidMapping("%s: partition or clustering columns can't have an index", this.messagePrefix);
                throw SkipException.INSTANCE;
            }
            if (isUdtField) {
                this.invalidMapping("%s: UDT fields can't have an index", this.messagePrefix);
                throw SkipException.INSTANCE;
            }
        }
        return cqlIndexDirective.map(d -> new IndexModelBuilder((Directive)d, this.parentCqlName, cqlName, cqlType, this.messagePrefix, this.context).build());
    }
}

