/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import graphql.GraphqlErrorException;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.migration.AddTableColumnQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.AddUdtFieldQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.CassandraSchemaHelper;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateIndexQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateTableQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateUdtQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.DropTableQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.DropUdtQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationStrategy;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.util.DirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CassandraMigrator {
    private static final BiFunction<UserDefinedType, SecondaryIndex, MigrationQuery> UDT_NO_CREATE_INDEX = (table, index) -> {
        throw new AssertionError((Object)"This should never get invoked since UDT fields can't be indexed");
    };
    private final MigrationStrategy strategy;
    private final boolean isPersisted;

    public static CassandraMigrator forDeployment(MigrationStrategy strategy) {
        return new CassandraMigrator(strategy, false);
    }

    public static CassandraMigrator forPersisted() {
        return new CassandraMigrator(MigrationStrategy.USE_EXISTING, true);
    }

    private CassandraMigrator(MigrationStrategy strategy, boolean isPersisted) {
        this.strategy = strategy;
        this.isPersisted = isPersisted;
    }

    public List<MigrationQuery> compute(MappingModel mappingModel, Keyspace keyspace) {
        ArrayList<MigrationQuery> queries = new ArrayList<MigrationQuery>();
        ArrayList<String> errors = new ArrayList<String>();
        block4: for (EntityModel entity : mappingModel.getEntities().values()) {
            switch (entity.getTarget()) {
                case TABLE: {
                    Table expectedTable = entity.getTableCqlSchema();
                    Table actualTable = keyspace.table(entity.getCqlName());
                    this.compute(expectedTable, actualTable, CassandraSchemaHelper::compare, CreateTableQuery::createTableAndIndexes, DropTableQuery::new, AddTableColumnQuery::new, CreateIndexQuery::new, "table", queries, errors);
                    continue block4;
                }
                case UDT: {
                    UserDefinedType expectedType = entity.getUdtCqlSchema();
                    UserDefinedType actualType = keyspace.userDefinedType(entity.getCqlName());
                    this.compute(expectedType, actualType, CassandraSchemaHelper::compare, CreateUdtQuery::createUdt, DropUdtQuery::new, AddUdtFieldQuery::new, UDT_NO_CREATE_INDEX, "UDT", queries, errors);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unexpected target " + (Object)((Object)entity.getTarget())));
        }
        if (!errors.isEmpty()) {
            String message = this.isPersisted ? "The GraphQL schema stored for this keyspace doesn't match the CQL data model anymore. It looks like the database was altered manually." : String.format("The GraphQL schema that you provided can't be mapped to the current CQL data model. Consider using a different migration strategy (current: %s).", new Object[]{this.strategy});
            throw ((GraphqlErrorException.Builder)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().message(message + " See details in `extensions.migrationErrors` below.")).extensions((Map)ImmutableMap.of((Object)"migrationErrors", errors))).build();
        }
        return CassandraMigrator.sortForExecution(queries);
    }

    private <T extends SchemaEntity> void compute(T expected, T actual, BiFunction<T, T, List<CassandraSchemaHelper.Difference>> comparator, Function<T, List<MigrationQuery>> createBuilder, Function<T, MigrationQuery> dropBuilder, BiFunction<T, Column, MigrationQuery> addColumnBuilder, BiFunction<T, SecondaryIndex, MigrationQuery> createIndexBuilder, String entityType, List<MigrationQuery> queries, List<String> errors) {
        switch (this.strategy) {
            case USE_EXISTING: {
                if (actual == null) {
                    errors.add(String.format("Missing %s %s", entityType, expected.name()));
                    break;
                }
                this.failIfMismatch(expected, actual, comparator, errors);
                break;
            }
            case ADD_MISSING_TABLES: {
                if (actual == null) {
                    queries.addAll((Collection<MigrationQuery>)createBuilder.apply(expected));
                    break;
                }
                this.failIfMismatch(expected, actual, comparator, errors);
                break;
            }
            case ADD_MISSING_TABLES_AND_COLUMNS: {
                if (actual == null) {
                    queries.addAll((Collection<MigrationQuery>)createBuilder.apply(expected));
                    break;
                }
                this.addMissingColumns(expected, actual, comparator, addColumnBuilder, createIndexBuilder, queries, errors);
                break;
            }
            case DROP_AND_RECREATE_ALL: {
                queries.add(dropBuilder.apply(expected));
                queries.addAll((Collection<MigrationQuery>)createBuilder.apply(expected));
                break;
            }
            case DROP_AND_RECREATE_IF_MISMATCH: {
                if (actual == null) {
                    queries.addAll((Collection<MigrationQuery>)createBuilder.apply(expected));
                    break;
                }
                List<CassandraSchemaHelper.Difference> differences = comparator.apply(expected, actual);
                if (differences.isEmpty()) break;
                queries.add(dropBuilder.apply(expected));
                queries.addAll((Collection<MigrationQuery>)createBuilder.apply(expected));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected strategy " + (Object)((Object)this.strategy)));
            }
        }
    }

    private <T extends SchemaEntity> void failIfMismatch(T expected, T actual, BiFunction<T, T, List<CassandraSchemaHelper.Difference>> comparator, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = comparator.apply(expected, actual);
        if (!differences.isEmpty()) {
            errors.addAll(differences.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
        }
    }

    private <T extends SchemaEntity> void addMissingColumns(T expected, T actual, BiFunction<T, T, List<CassandraSchemaHelper.Difference>> comparator, BiFunction<T, Column, MigrationQuery> addColumnBuilder, BiFunction<T, SecondaryIndex, MigrationQuery> createIndexBuilder, List<MigrationQuery> queries, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = comparator.apply(expected, actual);
        if (!differences.isEmpty()) {
            List blockers = differences.stream().filter(d -> !this.isAddableColumn((CassandraSchemaHelper.Difference)d)).collect(Collectors.toList());
            if (blockers.isEmpty()) {
                for (CassandraSchemaHelper.Difference difference : differences) {
                    assert (this.isAddableColumn(difference));
                    if (difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_COLUMN) {
                        queries.add(addColumnBuilder.apply(expected, difference.getColumn()));
                        continue;
                    }
                    if (difference.getType() != CassandraSchemaHelper.DifferenceType.MISSING_INDEX) continue;
                    queries.add(createIndexBuilder.apply(expected, difference.getIndex()));
                }
            } else {
                errors.addAll(blockers.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
            }
        }
    }

    private boolean isAddableColumn(CassandraSchemaHelper.Difference difference) {
        return (difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_COLUMN || difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_INDEX) && !difference.getColumn().isPartitionKey() && !difference.getColumn().isClusteringKey();
    }

    @VisibleForTesting
    static List<MigrationQuery> sortForExecution(List<MigrationQuery> queries) {
        if (queries.size() < 2) {
            return queries;
        }
        DirectedGraph<MigrationQuery> graph = new DirectedGraph<MigrationQuery>((Collection<MigrationQuery>)queries);
        for (MigrationQuery query1 : queries) {
            for (MigrationQuery query2 : queries) {
                boolean isSame = query1 != query2;
                if (!isSame || !query1.mustRunBefore(query2)) continue;
                graph.addEdge(query1, query2);
            }
        }
        return graph.topologicalSort();
    }
}

