/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.FederatedEntity;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FederatedEntityFetcher
extends DeployedFetcher<List<FederatedEntity>> {
    private final MappingModel mappingModel;

    public FederatedEntityFetcher(MappingModel mappingModel, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(mappingModel, authorizationService, dataStoreFactory);
        this.mappingModel = mappingModel;
    }

    @Override
    protected List<FederatedEntity> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws UnauthorizedException {
        ArrayList<FederatedEntity> result = new ArrayList<FederatedEntity>();
        for (Map representation : (List)environment.getArgument("representations")) {
            result.add(this.getEntity(representation, dataStore, authenticationSubject));
        }
        return result;
    }

    private FederatedEntity getEntity(Map<String, Object> representation, DataStore dataStore, AuthenticationSubject authenticationSubject) throws UnauthorizedException {
        Object rawTypeName = representation.get("__typename");
        if (!(rawTypeName instanceof String)) {
            throw new IllegalArgumentException("Entity representations must contain a '__typename' string field");
        }
        String entityName = (String)rawTypeName;
        EntityModel entityModel = this.mappingModel.getEntities().get(entityName);
        if (entityModel == null) {
            throw new IllegalArgumentException(String.format("Unknown entity type %s", entityName));
        }
        Keyspace keyspace = dataStore.schema().keyspace(entityModel.getKeyspaceName());
        List<BuiltCondition> whereConditions = this.bind(entityModel.getPrimaryKeyWhereConditions(), entityModel, representation::containsKey, representation::get, keyspace);
        ResultSet resultSet = this.query(entityModel, whereConditions, Optional.empty(), Optional.empty(), Optional.empty(), dataStore, authenticationSubject);
        Map<String, Object> entity = this.toSingleEntity(resultSet, entityModel);
        return FederatedEntity.wrap(entityModel, entity);
    }
}

