/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.CassandraFetcher;
import java.util.UUID;

public class UndeploySchemaFetcher
extends CassandraFetcher<Boolean> {
    public UndeploySchemaFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authorizationService, dataStoreFactory);
    }

    @Override
    protected Boolean get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws Exception {
        String keyspaceName = (String)environment.getArgument("keyspace");
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            throw new IllegalArgumentException(String.format("Keyspace '%s' does not exist.", keyspaceName));
        }
        this.authorizationService.authorizeSchemaWrite(authenticationSubject, keyspaceName, null, Scope.MODIFY, SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
        UUID expectedVersion = this.getExpectedVersion(environment);
        boolean force = (Boolean)environment.getArgument("force");
        new SchemaSourceDao(dataStore).undeploy(keyspaceName, expectedVersion, force);
        return true;
    }

    private UUID getExpectedVersion(DataFetchingEnvironment environment) {
        try {
            return UUID.fromString((String)environment.getArgument("expectedVersion"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid 'expectedVersion' value.");
        }
    }
}

