/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import com.google.common.annotations.VisibleForTesting;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.SchemaFetcher;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class SingleSchemaFetcher
extends SchemaFetcher<SchemaSource> {
    private final Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider;

    public SingleSchemaFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this(authorizationService, dataStoreFactory, SchemaSourceDao::new);
    }

    @VisibleForTesting
    public SingleSchemaFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory, Function<DataStore, SchemaSourceDao> schemaSourceDaoProvider) {
        super(authorizationService, dataStoreFactory);
        this.schemaSourceDaoProvider = schemaSourceDaoProvider;
    }

    @Override
    protected SchemaSource get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws Exception {
        String keyspace = this.getKeyspace(environment, dataStore);
        Optional<UUID> version = Optional.ofNullable((String)environment.getArgument("version")).map(UUID::fromString);
        this.authorize(authenticationSubject, keyspace);
        return this.schemaSourceDaoProvider.apply(dataStore).getSingleVersion(keyspace, version);
    }
}

