/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.graphql.schema.CassandraFetcher;
import java.util.Collections;

public abstract class SchemaFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    public SchemaFetcher(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authorizationService, dataStoreFactory);
    }

    protected void authorize(AuthenticationSubject authenticationSubject, String keyspace) throws UnauthorizedException {
        this.authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList("stargate_graphql"), Collections.singletonList("schema_source"), SourceAPI.GRAPHQL, ResourceKind.TABLE);
        this.authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspace), Collections.emptyList(), SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
    }

    protected String getKeyspace(DataFetchingEnvironment environment, DataStore dataStore) {
        String keyspace = (String)environment.getArgument("keyspace");
        if (!dataStore.schema().keyspaceNames().contains(keyspace)) {
            throw new IllegalArgumentException(String.format("Keyspace '%s' does not exist.", keyspace));
        }
        return keyspace;
    }
}

