/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst;

import graphql.Scalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.AllSchemasFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.DeploySchemaFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.DeploySchemaFileFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.SingleSchemaFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.UndeploySchemaFetcher;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationStrategy;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingLogType;
import java.io.InputStream;

public class AdminSchemaBuilder {
    private static final GraphQLObjectType SCHEMA_TYPE = GraphQLObjectType.newObject().name("Schema").description("The GraphQL schema that is deployed in a keyspace").field(GraphQLFieldDefinition.newFieldDefinition().name("keyspace").description("The name of the keyspace.").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("version").description("The version of the schema.").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("deployDate").description("The date that this version was deployed.").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("contents").description("The contents that were provided to the `deploySchema` mutation.\nNote that this is a partial schema: the actual schema used at runtime is augmented with directive definitions, generated types, etc.").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("contentsUri").description(String.format("A link to download `contents` as a file.%nIt is relative to the URI (ending in %s) that was used to execute this GraphQL request.", "/graphql-admin")).type((GraphQLOutputType)Scalars.GraphQLString).build()).build();
    private static final GraphQLFieldDefinition SCHEMA_QUERY = GraphQLFieldDefinition.newFieldDefinition().name("schema").description("Retrieves the GraphQL schema that is deployed in a keyspace").argument(GraphQLArgument.newArgument().name("keyspace").description("The name of the keyspace").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("version").description("The version of the schema to get. If not specified, it will return the latest version.").type((GraphQLInputType)Scalars.GraphQLString)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)SCHEMA_TYPE)).build();
    private static final GraphQLFieldDefinition SCHEMA_HISTORY_PER_KEYSPACE_QUERY = GraphQLFieldDefinition.newFieldDefinition().name("schemas").description("Retrieves all GraphQL schemas that are deployed in a keyspace").argument(GraphQLArgument.newArgument().name("keyspace").description("The name of the keyspace").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)SCHEMA_TYPE)).build();
    private static final GraphQLObjectType QUERY = GraphQLObjectType.newObject().name("Query").field(SCHEMA_QUERY).field(SCHEMA_HISTORY_PER_KEYSPACE_QUERY).build();
    private static final GraphQLFieldDefinition QUERY_FIELD = GraphQLFieldDefinition.newFieldDefinition().name("query").description("A reference to the `Query` object, in case you need to chain queries after the mutation.").type((GraphQLOutputType)QUERY).build();
    public static final GraphQLEnumType MIGRATION_STRATEGY_ENUM = GraphQLEnumType.newEnum().name("MigrationStrategy").description("What to do if the CQL schema doesn't match the provided GraphQL schema. Note that a table will be considered matching even if it contains additional columns not present in the GraphQL schema. In other words, a deploy operation will never drop columns.").value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(MigrationStrategy.USE_EXISTING.name()).value((Object)MigrationStrategy.USE_EXISTING).description("Don't do anything. All CQL tables and UDTs must match, otherwise the deployment is aborted. This is the most conservative strategy.").build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(MigrationStrategy.ADD_MISSING_TABLES.name()).value((Object)MigrationStrategy.ADD_MISSING_TABLES).description("Create CQL tables and UDTs that don't already exist. Those that exist must match, otherwise the deployment is aborted.").build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(MigrationStrategy.ADD_MISSING_TABLES_AND_COLUMNS.name()).value((Object)MigrationStrategy.ADD_MISSING_TABLES_AND_COLUMNS).description("Create CQL tables and UDTs that don't already exist. For those that exist, add any missing columns (as long as they're not marked as partition key or clustering). Note that this could still fail if the column existed before with a different type.").build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(MigrationStrategy.DROP_AND_RECREATE_ALL.name()).value((Object)MigrationStrategy.DROP_AND_RECREATE_ALL).description("Drop and recreate all CQL tables and UDTs. This is a destructive operation: any existing data will be lost.").build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(MigrationStrategy.DROP_AND_RECREATE_IF_MISMATCH.name()).value((Object)MigrationStrategy.DROP_AND_RECREATE_IF_MISMATCH).description("Drop and recreate only the CQL tables and UDTs that don't match. This is a destructive operation: any existing data in those tables will be lost (however, tables that didn't change will keep their data).").build()).build();
    private static final GraphQLEnumType LOG_CATEGORY_ENUM = GraphQLEnumType.newEnum().name("LogCategory").description("The categories of logs emitted by deploy mutations.").value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(ProcessingLogType.Info.name().toUpperCase()).value((Object)ProcessingLogType.Info).build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(ProcessingLogType.Warning.name().toUpperCase()).value((Object)ProcessingLogType.Warning).build()).build();
    private static final GraphQLObjectType LOCATION_TYPE = GraphQLObjectType.newObject().name("Location").description("A location in the GraphQL schema passed to a deploy mutation.").field(GraphQLFieldDefinition.newFieldDefinition().name("line").type((GraphQLOutputType)Scalars.GraphQLInt).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("column").type((GraphQLOutputType)Scalars.GraphQLInt).build()).build();
    private static final GraphQLObjectType LOG_TYPE = GraphQLObjectType.newObject().name("Log").description("A log emitted by a deploy mutation.").field(GraphQLFieldDefinition.newFieldDefinition().name("message").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("category").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)LOG_CATEGORY_ENUM)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("locations").type((GraphQLOutputType)GraphQLList.list((GraphQLType)LOCATION_TYPE)).build()).build();
    private static final GraphQLObjectType DEPLOY_SCHEMA_TYPE = GraphQLObjectType.newObject().name("DeploySchemaResponse").description("The outcome of a `deploySchema` mutation").field(GraphQLFieldDefinition.newFieldDefinition().name("version").description("The new schema version that was created by this operation.").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("logs").description("Warnings or info logs emitted during the deployment.\nNote that errors are reported as a GraphQL error, not here.").argument(GraphQLArgument.newArgument().name("category").description("Filter the logs to a particular category").type((GraphQLInputType)LOG_CATEGORY_ENUM).build()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)LOG_TYPE)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("cqlChanges").description("The queries that were executed to adapt the CQL data model to the new schema.").type((GraphQLOutputType)GraphQLList.list((GraphQLType)Scalars.GraphQLString)).build()).field(QUERY_FIELD).build();
    private static final GraphQLFieldDefinition DEPLOY_SCHEMA_MUTATION = AdminSchemaBuilder.deploySchemaStart().name("deploySchema").description("Deploys a GraphQL schema to a keyspace.").argument(GraphQLArgument.newArgument().name("schema").description("The contents of the schema.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).build();
    private static final GraphQLScalarType UPLOAD_SCALAR = GraphQLScalarType.newScalar().name("Upload").coercing((Coercing)new InputStreamCoercing()).build();
    private static final GraphQLFieldDefinition DEPLOY_SCHEMA_FILE_MUTATION = AdminSchemaBuilder.deploySchemaStart().name("deploySchemaFile").description("Deploys a GraphQL schema to a keyspace via a file upload.\nThis mutation must be executed with a [multipart request](https://github.com/jaydenseric/graphql-multipart-request-spec) (note that your `operations` part **must** declare MIME type `application/json`).").argument(GraphQLArgument.newArgument().name("schemaFile").description("The contents of the schema as an UTF-8 encoded file.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)UPLOAD_SCALAR)).build()).build();
    private static final GraphQLFieldDefinition UNDEPLOY_SCHEMA_MUTATION = GraphQLFieldDefinition.newFieldDefinition().name("undeploySchema").description("Cancels a previous deployment.\nThe keyspace will revert to the generated, \"CQL-first\" schema. The schema history will be preserved, but with all versions marked as `current: false`.").argument(GraphQLArgument.newArgument().name("keyspace").description("The keyspace to deploy to.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("expectedVersion").description("The current version.\nThis is used to ensure that another user is not deploying concurrently.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("force").description("Proceed even if the previous deployment is still marked as in progress. This is used to recover manually if a previous deployment failed unexpectedly during the CQL migration phase.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLBoolean)).defaultValue((Object)false).build()).type((GraphQLOutputType)Scalars.GraphQLBoolean).build();
    private static final GraphQLObjectType MUTATION = GraphQLObjectType.newObject().name("Mutation").field(DEPLOY_SCHEMA_MUTATION).field(DEPLOY_SCHEMA_FILE_MUTATION).field(UNDEPLOY_SCHEMA_MUTATION).build();
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;

    public AdminSchemaBuilder(AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
    }

    private static GraphQLFieldDefinition.Builder deploySchemaStart() {
        return GraphQLFieldDefinition.newFieldDefinition().argument(GraphQLArgument.newArgument().name("keyspace").description("The keyspace to deploy to.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("expectedVersion").description("The version that those changes apply to, or null if this is the first deployment.\nThis is used to prevent concurrent updates.").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("migrationStrategy").description("The strategy to update the CQL schema if necessary.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)MIGRATION_STRATEGY_ENUM)).defaultValue((Object)MigrationStrategy.ADD_MISSING_TABLES_AND_COLUMNS).build()).argument(GraphQLArgument.newArgument().name("force").description("Proceed even if the previous deployment is still marked as in progress. This is used to recover manually if a previous deployment failed unexpectedly during the CQL migration phase.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLBoolean)).defaultValue((Object)false).build()).argument(GraphQLArgument.newArgument().name("dryRun").description("Just parse and validate the schema, don't deploy it or apply any changes to the database. This is useful in particular in conjunction with the `cqlChanges` field in the result, to evaluate the impacts on the CQL data model.").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLBoolean)).defaultValue((Object)false).build()).type((GraphQLOutputType)DEPLOY_SCHEMA_TYPE);
    }

    public GraphQLSchema build() {
        return GraphQLSchema.newSchema().query(QUERY).mutation(MUTATION).codeRegistry(GraphQLCodeRegistry.newCodeRegistry().dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)QUERY, (GraphQLFieldDefinition)SCHEMA_QUERY), (DataFetcher)new SingleSchemaFetcher(this.authorizationService, this.dataStoreFactory)).dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)QUERY, (GraphQLFieldDefinition)SCHEMA_HISTORY_PER_KEYSPACE_QUERY), (DataFetcher)new AllSchemasFetcher(this.authorizationService, this.dataStoreFactory)).dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)MUTATION, (GraphQLFieldDefinition)DEPLOY_SCHEMA_MUTATION), (DataFetcher)new DeploySchemaFetcher(this.authorizationService, this.dataStoreFactory)).dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)MUTATION, (GraphQLFieldDefinition)DEPLOY_SCHEMA_FILE_MUTATION), (DataFetcher)new DeploySchemaFileFetcher(this.authorizationService, this.dataStoreFactory)).dataFetcher(FieldCoordinates.coordinates((GraphQLFieldsContainer)MUTATION, (GraphQLFieldDefinition)UNDEPLOY_SCHEMA_MUTATION), (DataFetcher)new UndeploySchemaFetcher(this.authorizationService, this.dataStoreFactory)).build()).build();
    }

    private static class InputStreamCoercing
    implements Coercing<InputStream, Void> {
        private InputStreamCoercing() {
        }

        public Void serialize(Object dataFetcherResult) throws CoercingSerializeException {
            throw new CoercingSerializeException("Upload can only be used for input");
        }

        public InputStream parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof InputStream) {
                return (InputStream)input;
            }
            if (input == null) {
                return null;
            }
            throw new CoercingParseValueException(String.format("Expected a FileInputStream, got %s", input.getClass().getSimpleName()));
        }

        public InputStream parseLiteral(Object input) throws CoercingParseLiteralException {
            throw new CoercingParseLiteralException("Upload values must be specified as JSON variables");
        }
    }
}

