/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BulkMutationFetcher
extends DmlFetcher<CompletableFuture<List<Map<String, Object>>>> {
    protected BulkMutationFetcher(Table table, NameMapping nameMapping, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(table, nameMapping, authorizationService, dataStoreFactory);
    }

    @Override
    protected CompletableFuture<List<Map<String, Object>>> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) {
        List<Object> queries = new ArrayList();
        Exception buildException = null;
        try {
            queries = this.buildQueries(environment, dataStore, authenticationSubject);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (operation.getDirectives().stream().anyMatch(d -> d.getName().equals("atomic")) && operation.getSelectionSet().getSelections().size() > 1) {
            return this.executeAsBatch(environment, dataStore, queries, buildException);
        }
        if (buildException != null) {
            CompletableFuture<List<Map<String, Object>>> f = new CompletableFuture<List<Map<String, Object>>>();
            f.completeExceptionally(buildException);
            return f;
        }
        List values = (List)environment.getArgument("values");
        if (values.size() != queries.size()) {
            throw new IllegalStateException("Number of values to insert should match number of queries");
        }
        ArrayList results = new ArrayList(values.size());
        for (int i = 0; i < queries.size(); ++i) {
            int finalI = i;
            results.add((CompletableFuture)dataStore.execute((BoundQuery)queries.get(i)).thenApply(rs -> this.toMutationResult((ResultSet)rs, values.get(finalI))));
        }
        return BulkMutationFetcher.convert(results);
    }

    private CompletableFuture<List<Map<String, Object>>> executeAsBatch(DataFetchingEnvironment environment, DataStore dataStore, List<BoundQuery> queries, Exception buildException) {
        boolean dataStoreAlreadySet;
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        HttpAwareContext context = (HttpAwareContext)environment.getContext();
        HttpAwareContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && (dataStoreAlreadySet = batchContext.setDataStore(dataStore))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(queries) == selections) {
            DataStore batchDataStore = batchContext.getDataStore().orElse(dataStore);
            batchContext.setExecutionResult(batchDataStore.batch(batchContext.getQueries()));
        }
        List values = (List)environment.getArgument("values");
        return batchContext.getExecutionFuture().thenApply(rs -> this.toListOfMutationResults((ResultSet)rs, values));
    }

    public static <T> CompletableFuture<List<T>> convert(List<CompletableFuture<T>> futures) {
        return futures.stream().map(f -> f.thenApply(Stream::of)).reduce((a, b) -> a.thenCompose(xs -> b.thenApply(ys -> Stream.concat(xs, ys)))).map(f -> f.thenApply(s -> s.collect(Collectors.toList()))).orElse(CompletableFuture.completedFuture(Collections.emptyList()));
    }

    protected abstract List<BoundQuery> buildQueries(DataFetchingEnvironment var1, DataStore var2, AuthenticationSubject var3) throws Exception;
}

