/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources.cqlfirst;

import graphql.GraphQL;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.graphql.web.RequestToHeadersMapper;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.Authenticated;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.GraphqlResourceBase;
import io.stargate.graphql.web.resources.cqlfirst.GraphqlCache;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/graphql")
@Singleton
@Authenticated
public class GraphqlDmlResource
extends GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlDmlResource.class);
    private static final Pattern KEYSPACE_NAME_PATTERN = Pattern.compile("\\w+");
    @Inject
    private GraphqlCache graphqlCache;
    @Inject
    private AuthorizationService authorizationService;

    @GET
    public void get(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.get(query, operationName, variables, graphql, httpRequest, asyncResponse);
        }
    }

    @GET
    @Path(value="/{keyspaceName}")
    public void get(@PathParam(value="keyspaceName") String keyspaceName, @QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.get(query, operationName, variables, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/json"})
    public void postJson(@PathParam(value="keyspaceName") String keyspaceName, GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Consumes(value={"application/graphql"})
    public void postGraphql(String query, @Context HttpServletRequest httpRequest, @HeaderParam(value="X-Cassandra-Token") String token, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getDefaultGraphql(httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postGraphql(query, graphql, httpRequest, asyncResponse);
        }
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/graphql"})
    public void postGraphql(@PathParam(value="keyspaceName") String keyspaceName, String query, @Context HttpServletRequest httpRequest, @HeaderParam(value="X-Cassandra-Token") String token, @Suspended AsyncResponse asyncResponse) {
        GraphQL graphql = this.getGraphl(keyspaceName, httpRequest, asyncResponse);
        if (graphql != null) {
            GraphqlDmlResource.postGraphql(query, graphql, httpRequest, asyncResponse);
        }
    }

    private GraphQL getDefaultGraphql(HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        GraphQL graphql = this.graphqlCache.getDefaultDml(RequestToHeadersMapper.getAllHeaders(httpRequest));
        if (graphql == null) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.NOT_FOUND, "No default keyspace defined", asyncResponse);
            return null;
        }
        if (!this.isAuthorized(httpRequest, this.graphqlCache.getDefaultKeyspaceName())) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.UNAUTHORIZED, "Not authorized", asyncResponse);
            return null;
        }
        return graphql;
    }

    private GraphQL getGraphl(String keyspaceName, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        if (!KEYSPACE_NAME_PATTERN.matcher(keyspaceName).matches()) {
            LOG.warn("Invalid keyspace in URI, this could be an XSS attack: {}", (Object)keyspaceName);
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Invalid keyspace name", asyncResponse);
            return null;
        }
        if (!this.isAuthorized(httpRequest, keyspaceName)) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.UNAUTHORIZED, "Not authorized", asyncResponse);
            return null;
        }
        GraphQL graphql = this.graphqlCache.getDml(keyspaceName, (AuthenticationSubject)httpRequest.getAttribute(AuthenticationFilter.SUBJECT_KEY), RequestToHeadersMapper.getAllHeaders(httpRequest));
        if (graphql == null) {
            GraphqlDmlResource.replyWithGraphqlError(Response.Status.NOT_FOUND, String.format("Unknown keyspace '%s'", keyspaceName), asyncResponse);
            return null;
        }
        return graphql;
    }

    private boolean isAuthorized(HttpServletRequest httpRequest, String keyspaceName) {
        AuthenticationSubject subject = (AuthenticationSubject)httpRequest.getAttribute(AuthenticationFilter.SUBJECT_KEY);
        try {
            this.authorizationService.authorizeSchemaRead(subject, Collections.singletonList(keyspaceName), Collections.emptyList(), SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
            return true;
        }
        catch (UnauthorizedException e) {
            return false;
        }
    }
}

