/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources.cqlfirst;

import graphql.GraphQL;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.Authenticated;
import io.stargate.graphql.web.resources.GraphqlResourceBase;
import io.stargate.graphql.web.resources.cqlfirst.GraphqlCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Path(value="/graphql-schema")
@Singleton
@Authenticated
public class GraphqlDdlResource
extends GraphqlResourceBase {
    private final GraphQL graphql;

    @Inject
    public GraphqlDdlResource(GraphqlCache graphqlCache) {
        this.graphql = graphqlCache.getDdl();
    }

    @GET
    public void get(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphqlDdlResource.get(query, operationName, variables, this.graphql, httpRequest, asyncResponse);
    }

    @POST
    @Consumes(value={"application/json"})
    public void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphqlDdlResource.postJson(jsonBody, queryFromUrl, this.graphql, httpRequest, asyncResponse);
    }

    @POST
    @Consumes(value={"application/graphql"})
    public void postGraphql(String query, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        GraphqlDdlResource.postGraphql(query, this.graphql, httpRequest, asyncResponse);
    }
}

