/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources.cqlfirst;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.cqlfirst.SchemaFactory;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlCache
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlCache.class);
    private static final boolean DISABLE_DEFAULT_KEYSPACE = Boolean.getBoolean("stargate.graphql.default_keyspace.disabled");
    private final Persistence persistence;
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    private final GraphQL ddlGraphql;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, GraphQL> dmlGraphqls = new ConcurrentHashMap<String, GraphQL>();

    public GraphqlCache(Persistence persistence, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this.persistence = persistence;
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema(authorizationService, dataStoreFactory));
        this.defaultKeyspace = GraphqlCache.findDefaultKeyspace(dataStoreFactory.createInternal());
        persistence.registerEventListener((EventListener)this);
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getDml(String keyspaceName, AuthenticationSubject subject, Map<String, String> headers) {
        String decoratedKeyspaceName = this.persistence.decorateKeyspaceName(keyspaceName, headers);
        return this.dmlGraphqls.computeIfAbsent(decoratedKeyspaceName, __ -> this.buildDmlGraphql(keyspaceName, subject, headers));
    }

    public GraphQL getDefaultDml(Map<String, String> headers) {
        return this.defaultKeyspace == null ? null : this.getDml(this.defaultKeyspace, null, headers);
    }

    public String getDefaultKeyspaceName() {
        return this.defaultKeyspace;
    }

    private GraphQL buildDmlGraphql(String keyspaceName, AuthenticationSubject subject, Map<String, String> headers) {
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().putAllCustomProperties(headers).build();
        DataStore dataStore = subject == null ? this.dataStoreFactory.createInternal((DataStoreOptions)dataStoreOptions) : this.dataStoreFactory.create(subject.asUser(), (DataStoreOptions)dataStoreOptions);
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        return keyspace == null ? null : GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(this.authorizationService, keyspace, this.dataStoreFactory));
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL((GraphQLSchema)schema).mutationExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        if (DISABLE_DEFAULT_KEYSPACE) {
            return null;
        }
        try {
            CompletableFuture query = dataStore.queryBuilder().select().column("keyspace_name").writeTimeColumn("durable_writes", "wt").from("system_schema", "keyspaces").build().execute(ConsistencyLevel.LOCAL_QUORUM, new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Optional<Row> first = resultSet.rows().stream().filter(r -> !r.isNull("wt")).filter(r -> r.getLong("wt") > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong("wt")));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    public void onDropKeyspace(String decoratedKeyspaceName) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "it was dropped", new Object[0]);
    }

    public void onCreateTable(String decoratedKeyspaceName, String table) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "table %s was created", table);
    }

    public void onCreateView(String decoratedKeyspaceName, String view) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "view %s was created", view);
    }

    public void onCreateType(String decoratedKeyspaceName, String type) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "type %s was created", type);
    }

    public void onCreateFunction(String decoratedKeyspaceName, String function, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "function %s was created", function);
    }

    public void onCreateAggregate(String decoratedKeyspaceName, String aggregate, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "aggregate %s was created", aggregate);
    }

    public void onAlterTable(String decoratedKeyspaceName, String table) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "table %s was altered", table);
    }

    public void onAlterView(String decoratedKeyspaceName, String view) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "view %s was altered", view);
    }

    public void onAlterType(String decoratedKeyspaceName, String type) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "type %s was altered", type);
    }

    public void onAlterFunction(String decoratedKeyspaceName, String function, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "function %s was altered", function);
    }

    public void onAlterAggregate(String decoratedKeyspaceName, String aggregate, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "aggregate %s was altered", aggregate);
    }

    public void onDropTable(String decoratedKeyspaceName, String table) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "table %s was dropped", table);
    }

    public void onDropView(String decoratedKeyspaceName, String view) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "view %s was dropped", view);
    }

    public void onDropType(String decoratedKeyspaceName, String type) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "type %s was dropped", type);
    }

    public void onDropFunction(String decoratedKeyspaceName, String function, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "function %s was dropped", function);
    }

    public void onDropAggregate(String decoratedKeyspaceName, String aggregate, List<String> argumentTypes) {
        this.invalidateDmlGraphql(decoratedKeyspaceName, "aggregate %s was dropped", aggregate);
    }

    @FormatMethod
    private void invalidateDmlGraphql(String decoratedKeyspaceName, @FormatString String reason, Object ... reasonArguments) {
        GraphQL previous = (GraphQL)this.dmlGraphqls.remove(decoratedKeyspaceName);
        if (previous != null && LOG.isDebugEnabled()) {
            LOG.debug("Invalidated GraphQL schema for keyspace {} because {}", (Object)decoratedKeyspaceName, (Object)String.format(reason, reasonArguments));
        }
    }
}

