/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources.cqlfirst;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.cqlfirst.SchemaFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlCache
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlCache.class);
    private static final boolean DISABLE_DEFAULT_KEYSPACE = Boolean.getBoolean("stargate.graphql.default_keyspace.disabled");
    private final Persistence persistence;
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    private final GraphQL ddlGraphql;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, DmlGraphqlReference> dmlGraphqls;

    public GraphqlCache(Persistence persistence, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this.persistence = persistence;
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema(authorizationService, dataStoreFactory));
        DataStore dataStore = dataStoreFactory.createInternal();
        this.defaultKeyspace = GraphqlCache.findDefaultKeyspace(dataStore);
        this.dmlGraphqls = this.initDmlGraphqls(dataStore, authorizationService, dataStoreFactory);
        persistence.registerEventListener((EventListener)this);
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getDml(String keyspace, Map<String, String> headers) {
        String decoratedName = this.persistence.decorateKeyspaceName(keyspace, headers);
        DmlGraphqlReference ref = (DmlGraphqlReference)this.dmlGraphqls.get(decoratedName);
        return ref == null ? null : ref.get();
    }

    public GraphQL getDefaultDml() {
        return this.defaultKeyspace == null ? null : this.getDml(this.defaultKeyspace, Collections.emptyMap());
    }

    public String getDefaultKeyspaceName() {
        return this.defaultKeyspace;
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        if (DISABLE_DEFAULT_KEYSPACE) {
            return null;
        }
        try {
            CompletableFuture query = dataStore.queryBuilder().select().column("keyspace_name").writeTimeColumn("durable_writes", "wt").from("system_schema", "keyspaces").build().execute(ConsistencyLevel.LOCAL_QUORUM, new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Optional<Row> first = resultSet.rows().stream().filter(r -> !r.isNull("wt")).filter(r -> r.getLong("wt") > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong("wt")));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    private ConcurrentMap<String, DmlGraphqlReference> initDmlGraphqls(DataStore dataStore, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        ConcurrentHashMap<String, DmlGraphqlReference> map = new ConcurrentHashMap<String, DmlGraphqlReference>();
        for (Keyspace keyspace : dataStore.schema().keyspaces()) {
            String keyspaceName = keyspace.name();
            LOG.debug("Prepare GraphQL schema for {}", (Object)keyspaceName);
            map.put(keyspaceName, new DmlGraphqlReference(keyspace, authorizationService, dataStoreFactory));
        }
        return map;
    }

    @FormatMethod
    private void addOrReplaceDmlGraphql(String keyspaceName, @FormatString String reason, Object ... reasonArguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Refreshing GraphQL schema for keyspace {} because {}", (Object)keyspaceName, (Object)String.format(reason, reasonArguments));
        }
        try {
            DataStore dataStore = this.dataStoreFactory.createInternal();
            Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
            if (keyspace == null) {
                LOG.debug("Removing GraphQL schema for keyspace {} because it was dropped", (Object)keyspaceName);
                this.dmlGraphqls.remove(keyspaceName);
            } else {
                this.dmlGraphqls.put(keyspaceName, new DmlGraphqlReference(keyspace, this.authorizationService, this.dataStoreFactory));
            }
            LOG.debug("Done refreshing GraphQL schema for keyspace {}", (Object)keyspaceName);
        }
        catch (Exception e) {
            LOG.error("Error while refreshing GraphQL schema for keyspace {}", (Object)keyspaceName, (Object)e);
        }
    }

    public void onCreateKeyspace(String keyspaceName) {
        this.addOrReplaceDmlGraphql(keyspaceName, "it was created", new Object[0]);
    }

    public void onDropKeyspace(String keyspaceName) {
        DmlGraphqlReference removed = (DmlGraphqlReference)this.dmlGraphqls.remove(keyspaceName);
        if (removed != null) {
            LOG.debug("Removing GraphQL schema for keyspace {} because it was dropped", (Object)keyspaceName);
        }
    }

    public void onCreateTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was created", table);
    }

    public void onCreateView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was created", view);
    }

    public void onCreateType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was created", type);
    }

    public void onCreateFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was created", function);
    }

    public void onCreateAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was created", aggregate);
    }

    public void onAlterTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was altered", table);
    }

    public void onAlterView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was altered", view);
    }

    public void onAlterType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was altered", type);
    }

    public void onAlterFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was altered", function);
    }

    public void onAlterAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was altered", aggregate);
    }

    public void onDropTable(String keyspaceName, String table) {
        this.addOrReplaceDmlGraphql(keyspaceName, "table %s was dropped", table);
    }

    public void onDropView(String keyspaceName, String view) {
        this.addOrReplaceDmlGraphql(keyspaceName, "view %s was dropped", view);
    }

    public void onDropType(String keyspaceName, String type) {
        this.addOrReplaceDmlGraphql(keyspaceName, "type %s was dropped", type);
    }

    public void onDropFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "function %s was dropped", function);
    }

    public void onDropAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceDmlGraphql(keyspaceName, "aggregate %s was dropped", aggregate);
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL((GraphQLSchema)schema).mutationExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
    }

    static class DmlGraphqlReference {
        private final Keyspace keyspace;
        private final AuthorizationService authorizationService;
        private final DataStoreFactory dataStoreFactory;
        private volatile GraphQL graphql;

        DmlGraphqlReference(Keyspace keyspace, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
            this.keyspace = keyspace;
            this.authorizationService = authorizationService;
            this.dataStoreFactory = dataStoreFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GraphQL get() {
            GraphQL result = this.graphql;
            if (result != null) {
                return result;
            }
            DmlGraphqlReference dmlGraphqlReference = this;
            synchronized (dmlGraphqlReference) {
                if (this.graphql == null) {
                    this.graphql = GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(this.authorizationService, this.keyspace, this.dataStoreFactory));
                }
                return this.graphql;
            }
        }
    }
}

