/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.graphql.web.RequestToHeadersMapper;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class HttpAwareContext {
    private final HttpServletRequest request;
    private final AuthenticationSubject subject;
    private final BatchContext batchContext = new BatchContext();

    public HttpAwareContext(HttpServletRequest request) {
        this.request = request;
        this.subject = (AuthenticationSubject)request.getAttribute(AuthenticationFilter.SUBJECT_KEY);
        if (this.subject == null) {
            throw new AssertionError((Object)"Missing authentication subject in the request");
        }
    }

    public AuthenticationSubject getSubject() {
        return this.subject;
    }

    public Map<String, String> getAllHeaders() {
        return RequestToHeadersMapper.getAllHeaders(this.request);
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public static class BatchContext {
        private final List<BoundQuery> queries = new ArrayList<BoundQuery>();
        private final CompletableFuture<ResultSet> executionFuture = new CompletableFuture();
        private AtomicReference<DataStore> dataStore = new AtomicReference();

        public CompletableFuture<ResultSet> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<BoundQuery> getQueries() {
            return this.queries;
        }

        public void setExecutionResult(CompletableFuture<ResultSet> result) {
            ((CompletableFuture)result.thenApply(this.executionFuture::complete)).exceptionally(this.executionFuture::completeExceptionally);
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(BoundQuery query) {
            this.queries.add(query);
            return this.queries.size();
        }

        public boolean setDataStore(DataStore dataStore) {
            return this.dataStore.getAndSet(dataStore) != null;
        }

        public Optional<DataStore> getDataStore() {
            return Optional.ofNullable(this.dataStore.get());
        }
    }
}

