/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.types.scalars;

import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;

abstract class TemporalCoercing<DriverTypeT>
implements Coercing<DriverTypeT, String> {
    TemporalCoercing() {
    }

    protected abstract String format(DriverTypeT var1);

    protected abstract DriverTypeT parse(String var1);

    protected abstract DriverTypeT parse(long var1);

    public String serialize(Object dataFetcherResult) throws CoercingSerializeException {
        Object value = dataFetcherResult;
        return this.format(value);
    }

    public DriverTypeT parseValue(Object input) throws CoercingParseValueException {
        if (input instanceof String) {
            String s = (String)input;
            return this.parseSafe(s);
        }
        if (input instanceof BigInteger) {
            long longValue = this.fromBigIntegerSafe((BigInteger)input);
            return this.parseSafe(longValue);
        }
        if (input instanceof Integer || input instanceof Long) {
            return this.parseSafe(((Number)input).longValue());
        }
        throw new CoercingParseLiteralException("Expected a string or integer literal");
    }

    public DriverTypeT parseLiteral(Object input) throws CoercingParseLiteralException {
        if (input instanceof StringValue) {
            return this.parseSafe(((StringValue)input).getValue());
        }
        if (input instanceof IntValue) {
            BigInteger bi = ((IntValue)input).getValue();
            long longValue = this.fromBigIntegerSafe(bi);
            return this.parseSafe(longValue);
        }
        throw new CoercingParseLiteralException("Expected a string or integer literal");
    }

    private DriverTypeT parseSafe(String s) {
        try {
            return this.parse(s);
        }
        catch (CoercingParseLiteralException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoercingParseLiteralException(e.getMessage(), (Throwable)e);
        }
    }

    private DriverTypeT parseSafe(long l) {
        try {
            return this.parse(l);
        }
        catch (CoercingParseLiteralException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoercingParseLiteralException(e.getMessage(), (Throwable)e);
        }
    }

    private long fromBigIntegerSafe(BigInteger i) {
        try {
            return i.longValueExact();
        }
        catch (ArithmeticException e) {
            throw new CoercingParseLiteralException("Out of bounds");
        }
    }
}

