/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml;

import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableListType;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.types.scalars.CustomScalars;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class FieldTypeCache<GraphqlT> {
    protected final NameMapping nameMapping;
    private final Map<Column.ColumnType, GraphqlT> types = new HashMap<Column.ColumnType, GraphqlT>();

    FieldTypeCache(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    GraphqlT get(Column.ColumnType type) {
        type = this.normalize(type);
        return this.computeIfAbsent(type);
    }

    private GraphqlT computeIfAbsent(Column.ColumnType type) {
        GraphqlT result = this.types.get(type);
        if (result == null) {
            result = this.compute(type);
            this.types.put(type, result);
        }
        return result;
    }

    private Column.ColumnType normalize(Column.ColumnType type) {
        if ((type = type.frozen(false)).isSet()) {
            type = ImmutableListType.builder().addAllParameters((Iterable)type.parameters()).build();
        }
        if (type == Column.Type.Varchar) {
            type = Column.Type.Text;
        }
        return type;
    }

    protected abstract GraphqlT compute(Column.ColumnType var1);

    protected GraphQLScalarType getScalar(Column.Type type) {
        switch (type) {
            case Ascii: {
                return CustomScalars.ASCII;
            }
            case Bigint: {
                return CustomScalars.BIGINT;
            }
            case Blob: {
                return CustomScalars.BLOB;
            }
            case Boolean: {
                return Scalars.GraphQLBoolean;
            }
            case Counter: {
                return CustomScalars.COUNTER;
            }
            case Decimal: {
                return CustomScalars.DECIMAL;
            }
            case Double: {
                return Scalars.GraphQLFloat;
            }
            case Duration: {
                return CustomScalars.DURATION;
            }
            case Float: {
                return CustomScalars.FLOAT;
            }
            case Int: {
                return Scalars.GraphQLInt;
            }
            case Smallint: {
                return CustomScalars.SMALLINT;
            }
            case Tinyint: {
                return CustomScalars.TINYINT;
            }
            case Text: 
            case Varchar: {
                return Scalars.GraphQLString;
            }
            case Timestamp: {
                return CustomScalars.TIMESTAMP;
            }
            case Uuid: {
                return CustomScalars.UUID;
            }
            case Varint: {
                return CustomScalars.VARINT;
            }
            case Timeuuid: {
                return CustomScalars.TIMEUUID;
            }
            case Inet: {
                return CustomScalars.INET;
            }
            case Date: {
                return CustomScalars.DATE;
            }
            case Time: {
                return CustomScalars.TIME;
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type " + type);
    }
}

